package pcc.chemicraft.core.item;

import java.util.List;
import java.util.Random;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import pcc.chemicraft.ChemiCraft;
import pcc.chemicraft.core.ChemiCraftCore;
import pcc.chemicraft.util.AtomInfo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemAtoms extends Item {

	public ItemAtoms(int par1){
		super(par1);
		this.maxStackSize = 64;
		this.setHasSubtypes(true);
		this.setMaxDamage(0);
		this.setCreativeTab(ChemiCraftCore.instance.creativeTabChemiCraft);
	}



	@Override
	public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5)
	{
		if (AtomInfo.isRI(par1ItemStack.getItemDamage() + 1)){
			Random random = new Random();
			if (random.nextInt(100) == 0){
				if (par3Entity instanceof EntityLiving){
					EntityLiving entity = (EntityLiving)par3Entity;
					entity.attackEntityFrom(ChemiCraftCore.getRadiationDamageSource(entity), 1);
				}
				if (par3Entity instanceof EntityPlayer){
					EntityPlayer player = (EntityPlayer)par3Entity;
					ItemStack itemstack = new ItemStack(
							par1ItemStack.itemID,
							1,
							par1ItemStack.getItemDamage());
					itemstack.setItemDamage(AtomInfo.collapseUraniumSeries(itemstack.getItemDamage() + 1) - 1);
					player.inventory.addItemStackToInventory(itemstack);
					player.inventory.consumeInventoryItem(par1ItemStack.itemID);
				}
			}
		}
	}



	@SuppressWarnings({ "unchecked", "rawtypes" })
	@SideOnly(Side.CLIENT)
	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List){
		for(int type = 0; type < ChemiCraftCore.instance.ATOMSNAME.length; type++)
		{
			par3List.add(new ItemStack(par1, 1, type));
			this.setIconIndex(type);
		}
	}



	@Override
	public String getItemNameIS(ItemStack par1ItemStack){
		return super.getItemName() + "." + ChemiCraftCore.instance.ATOMSNAME[par1ItemStack.getItemDamage()];
	}



	@Override
	public String getTextureFile(){
		return ChemiCraft.ITEM_ATOMS_TEXTURE;
	}



	@SideOnly(Side.CLIENT)
	@Override
	public int getIconFromDamage(int par1){
		return par1;
	}

}