﻿package chemicraft;

import net.minecraft.src.Block;
import net.minecraft.src.CreativeTabs;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import chemicraft.Auxiliary.NameAuxiliary;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid = "chemiCraft", name = "ChemiCraft", version = "テスト版")
// ID,名前,バージョン
@NetworkMod(clientSideRequired = true, serverSideRequired = true, versionBounds = "[1.3.2]", channels = "chemicraft", packetHandler = PacketHandler.class)
// クライアント、サーバー共に必要 1.3.2用
public class ChemiCraft
{

	public static final String[] atomsName = { "Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluorine", "Neon",
			"Sodium", "Magnesium", "Aluminium", "Silicon", "Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium",
			"Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium", "Germanium", "Arsenic", "Selenium", "Bromine",
			"Krypton", "Rubidium", "Strontium", "Yttorium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium", "Silver",
			"Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Caesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium",
			"Promethium", "Samarium", "Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium",
			"Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum", "Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine",
			"Radon", "Francium", "Radium", "Actinium", "Thorium", "Protactinium", "Uranium", "Neptunium", "Plutonium", "Americium", "Curium", "Berkelium",
			"Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium",
			"Meitnerium", "Darmstadtium", "Roentgenium", "Copernicium", "Ununtrium", "Ununquadium", "Ununpentium", "Ununhexium", "", "Ununoctium" };

	public static final String[] atomsNameJP = { "水素", "ヘリウム", "リチウム", "ベリウム", "ホウ素", "炭素", "窒素", "酸素", "フッ素", "ネオン", "ナトリウム", "マグネシウム", "アルミニウム", "ケイ素", "リン",
			"硫黄", "塩素", "アルゴン", "カリウム", "カルシウム", "スカンジウム", "チタン", "バナジウム", "クロム", "マンガン", "鉄", "コバルト", "ニッケル", "銅", "亜鉛", "ガリウム", "ゲルマニウム", "ヒ素", "セレン", "臭素",
			"クリプトン", "ルビジウム", "ストロンチウム", "イットリウム", "ジルコニウム", "ニオブ", "モリブデン", "テクネチウム", "ルテニウム", "ロジウム", "パラジウム", "銀", "カドミウム", "インジウム", "スズ", "アンチモン", "テルル",
			"ヨウ素", "キセノン", "セシウム", "バリウム", "ランタン", "セリウム", "プラセオジム", "ネオジム", "プロメチウム", "サマリウム", "ユウロビウム", "ガドリニウム", "テルビウム", "ジスプロニウム", "ホルミウム", "エルビウム",
			"ツリウム", "イッテルビウム", "ルテチウム", "ハフニウム", "タンタル", "タングステン", "レニウム", "オスミウム", "イリジウム", "白金", "金", "水銀", "タリウム", "鉛", "ビスマス", "ポロニウム", "アスタチン", "ラドン",
			"フランシウム", "ラジウム", "アクチニウム", "トリウム", "プロトアクチウム", "ウラン", "ネプツニウム", "プルトニウム", "アメリシウム", "キュリウム", "バークリウム", "カルホルニウム", "アインスタイニウム", "フェルミウム",
			"メンデレビウム", "ノーベリウム", "ローレンシウム", "ラサホージウム", "ドブニウム", "シーボーギウム", "ボーリウム", "ハッシウム", "マイトネリウム", "ダームスタチウム", "レントゲニウム", "コペルニシウム", "ウンウントリウム",
			"ウンウンクアジウム", "ウンウンペンチウム", "ウンウンヘキシウム", "", "ウンウンオクチウム" };

	/**
	 * このmodのインスタンス
	 */
	@Mod.Instance("chemiCraft")
	public static ChemiCraft instance;

	/**
	 * ChemiCraftのProxy
	 */
	@SidedProxy(clientSide = "chemicraft.client.ClientProxy", serverSide = "chemicraft.CommonProxy")
	public static CommonProxy proxy;

	/**
	 * ChemiCraftのCreativeTab
	 */
	public static CreativeTabs creativeTab = new CreativeTabAtoms("ChemiCraft");

	/**
	 * ItemID
	 */
	public static int atomsID;
	public static int compoundsID;
	public static int gasCollectingBottleID;

	/**
	 * BlockID
	 */
	public static int scienceCraftingTableID;

	/**
	 * GUIID
	 */
	public static int guiScienceCraftingTableID;

	/**
	 * Block型変数
	 */
	public static Block blockScienceCraftingTable;

	/**
	 * Item型変数
	 */
	public static Item itemAtoms;
	public static Item itemCompounds;
	public static Item itemGasCollectingBottle;

	/**
	 * このmodに必要な補助クラスのインスタンス
	 */
	private static Auxiliary Auxiliary = new Auxiliary();
	private static NameAuxiliary NameAuxiliary = Auxiliary.new NameAuxiliary();

	@Mod.PreInit
	public void chemiPreLoadMethod(FMLPreInitializationEvent event)
	{
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		cfg.load();

		Property scienceCraftingTableIDProp = cfg.getBlock("scienceCraftingTable", 200);
		Property atomsIDProp = cfg.getItem("atomsID", 25000);
		Property compoundsIDProp = cfg.getItem("compoundsID", 25001);
		Property gasCollectingBottleIDProp = cfg.getItem("gasCollectingBottleID", 25002);
		Property guiScienceCraftingTableIDProp = cfg.get("GUI", "GUIScienceCraftingTableID", 1000);

		scienceCraftingTableID = scienceCraftingTableIDProp.getInt();
		atomsID = atomsIDProp.getInt();
		compoundsID = compoundsIDProp.getInt();
		gasCollectingBottleID = gasCollectingBottleIDProp.getInt();
		guiScienceCraftingTableID = guiScienceCraftingTableIDProp.getInt();

		cfg.save();
	}

	@Mod.PostInit
	public void chemiPostLoadMethod(FMLPostInitializationEvent event)
	{
		// API用の処理
		NameAuxiliary.addName(itemCompounds, ChemiCraftAPI.getCompoundsName().toArray());
		NameAuxiliary.addName(itemCompounds, "ja_JP", ChemiCraftAPI.getCompoundsLangName().toArray());

		// Blockを追加します
		blockScienceCraftingTable = new BlockScienceCraftingTable(scienceCraftingTableID, Block.workbench.blockIndexInTexture, Material.ground)
				.setHardness(2.0F).setResistance(0.0F).setStepSound(Block.soundStoneFootstep).setBlockName("ScienceCraftingTable");

		// Itemを追加します
		itemAtoms = new ItemAtoms(atomsID).setItemName("atoms");
		itemCompounds = new ItemCompounds(compoundsID).setItemName("compounds");
		itemGasCollectingBottle = new ItemGasCollectingBottle(gasCollectingBottleID).setItemName("gasCollectingBottle");

		// BlockをMinecraftに登録します
		GameRegistry.registerBlock(blockScienceCraftingTable);

		// Blockの名前を設定します
		NameAuxiliary.addName(blockScienceCraftingTable, "ScienceCraftingTable");
		NameAuxiliary.addName(blockScienceCraftingTable, "ja_JP", "科学作業台");

		// Itemの名前を設定します
		NameAuxiliary.addName(itemAtoms, atomsName);
		NameAuxiliary.addName(itemAtoms, "ja_JP", atomsNameJP);
		NameAuxiliary.addName(itemGasCollectingBottle, "GasCollectingBottle");
		NameAuxiliary.addName(itemGasCollectingBottle, "ja_JP", "集気瓶");

		// 化合物の名前を設定し追加します
		ChemiCraftAPI.addLangCompound("ja_JP", "Salt", "塩");

		// TileEntityを追加します
		GameRegistry.registerTileEntity(TileEntityScienceCraftingTable.class, "TileEntityScienceCraftingTable");

		// GUIを追加します
		NetworkRegistry.instance().registerGuiHandler(instance, proxy);

	}

}