package net.minecraft.src.ChemiCraft;

import java.util.List;

import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
import net.minecraft.src.CreativeTabs;
import net.minecraft.src.Entity;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemCompounds extends Item {

	public ItemCompounds(int par1) {
		super(par1);
		this.maxStackSize = 1;
		this.setHasSubtypes(true);
		this.setMaxDamage(0);
		this.setCreativeTab(ChemiCraft.tabAtoms);
	}

	@Override
	public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5){
		for(int i=0;i < ChemiCraftAPI.getCompoundsName().size();i++){
			for(int j=0;j < ChemiCraftAPI.getCompoundHandlerItemName().size();j++){
				if(ChemiCraftAPI.getCompoundsName().get(i).equals(ChemiCraftAPI.getCompoundHandlerItemName().get(i))){
					ChemiCraftAPI.getCompoundHandler().get(j).onUpdateHandler(par1ItemStack, par2World, par3Entity, par4, par5);
				}
			}
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
	{
		for(int type = 0; type < ChemiCraftAPI.getCompoundsName().toArray().length; type++)
		{
			par3List.add(new ItemStack(par1, 1, type));
			this.setIconIndex(type);
		}
	}

	@Override
	public String getItemNameIS(ItemStack par1ItemStack)
	{
		return super.getItemName() + "." + ChemiCraftAPI.getCompoundsName().toArray()[par1ItemStack.getItemDamage()];
	}

	@Override
	public String getTextureFile()
	{
		this.isDefaultTexture = false;
		return "/ChemiCraft/Compounds.png";
	}

	@SideOnly(Side.CLIENT)
	@Override
	public int getIconFromDamage(int par1)
	{
		return par1;
	}

}
