//
//  main.c
//  AI002
//
//  Created by 西田　耀 on 13/01/01.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include "core.h"

int main(int argc, const char * argv[])
{
    srand((unsigned int)time(NULL));
    AI_Environment_SetCurrentWorkingDirectory(argv[0]);
    AI_Memory_InitializeWorkingSet();
    
    if(argc >= 2){
        AI_MainMemory.filename = AI_String_ExtractByLength(argv[1], 0, PATH_MAX);
    } else{
        AI_MainMemory.filename = AI_String_ExtractByLength(AI_MEMORY_FILENAME, 0, PATH_MAX);
    }
    AI_Memory_ReadMemory(NULL);
    
    AI_ThinkMain();
    
    return 0;
}

int AI_Speak(char *format, ...)
{
    char s[AI_MAX_STRINGLENGTH];
    va_list varg;
    
    fputs("AI:", stdout);
    
    va_start(varg, format);
    vsnprintf(s, sizeof(s), format, varg);
    va_end(varg);
    
    fputs(s, stdout);
    
    return 0;
}


char *AI_ReadInput(char line[], int linesize, FILE *fp)
{
    char *retv;
    
    retv = fgets(line, linesize, fp);
    AI_String_DeleteCRLF(line);
    
    return retv;
}

int AI_strtol(const char s[], char **invalidchar, int base)
{
    if(s == NULL){
        return 0;
    }
    
    return (int)strtol(s, invalidchar, base);
}
