//
//  separate.c
//  AI002
//
//  Created by 西田　耀 on 13/01/01.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include "core.h"

int AI_Array_GetSeparatedStringByArray(AI_Array **separated, AI_Array *list, const char s[])
{
    int index, end, location;
    
    if(s == NULL){
        debug("s null\n", NULL);
        return 1;
    }
    
    end = 0;
    for(;;){
        index = AI_String_SearchLocationFromArray(&s[end], list, &location);
        if(index == AI_ARRAY_INDEX_NOTFOUND){
            //もうリストの文字列はない
            if(s[end] != '\0'){
                //でもまだ文字列は残っている
                AI_Array_AppendLast(separated, AI_DATAID_NULL, AI_String_ExtractByLength(&s[end], 0, AI_MAX_STRINGLENGTH));
            }
            break;
        }
        //リストの文字列が見つかった
        if(location != 0){
            //リストの文字列の前に、リストにない文字列がある
            AI_Array_AppendLast(separated, AI_DATAID_NULL, AI_String_ExtractByLength(&s[end], 0, location));
            end += location;
        }
        AI_Array_AppendLast(separated, AI_Array_GetDataIDByIndex(list, index), AI_String_ExtractByLength((char *)AI_Array_GetPointerByIndex(list, index), 0, AI_MAX_STRINGLENGTH));
        end += AI_String_GetLength(AI_Array_GetPointerByIndex(list, index));
    }
    return 0;
}

int AI_Array_GetSeparatedStringByArrayWithoutListWord(AI_Array **separated, AI_Array *list, const char s[])
{
    int index, end, location;
    
    if(s == NULL){
        debug("s null\n", NULL);
        return 1;
    }
    
    end = 0;
    for(;;){
        index = AI_String_SearchLocationFromArray(&s[end], list, &location);
        if(index == AI_ARRAY_INDEX_NOTFOUND){
            //もうリストの文字列はない
            if(s[end] != '\0'){
                //でもまだ文字列は残っている
                AI_Array_AppendLast(separated, AI_DATAID_NULL, AI_String_ExtractByLength(&s[end], 0, AI_MAX_STRINGLENGTH));
            }
            break;
        }
        //リストの文字列が見つかった
        if(location != 0){
            //リストの文字列の前に、リストにない文字列がある
            AI_Array_AppendLast(separated, AI_DATAID_NULL, AI_String_ExtractByLength(&s[end], 0, location));
            end += location;
        }
        //AI_Array_AppendLast(separated, AI_Array_GetDataNumberByIndex(list, index), AI_String_ExtractByLength((char *)AI_Array_GetPointerByIndex(list, index), 0, AI_MAX_STRINGLENGTH));
        end += AI_String_GetLength(AI_Array_GetPointerByIndex(list, index));
    }
    return 0;
}
