//
//  main.c
//  c2wiki
//
//  Created by 西田　耀 on 13/02/24.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include <stdio.h>
#include <time.h>
#include "chnlib.h"

int main(int argc, const char * argv[])
{
    FILE *fp, *outfile;
    CHNLIB_String *line;
    CHNLIB_UIPArray *root, *wordlist;
    int files;
    int i, i_max;
    int level, recording;
    time_t now;
    struct tm *pnow;
    char s[1024];
    
    CHNLIB_Environment_SetCurrentWorkingDirectory(argv[0]);
    
    if(argc < 2){
        printf("Usage: c2wiki csourcefile\n");
        return 0;
    }
    
    //解析用リストの初期化
    wordlist = CHNLIB_UIPArray_Initialize();
    CHNLIB_UIPArray_AppendLast(&wordlist, 1, CHNLIB_String_Initialize("{"));
    CHNLIB_UIPArray_AppendLast(&wordlist, 2, CHNLIB_String_Initialize("}"));
    CHNLIB_UIPArray_AppendLast(&wordlist, 3, CHNLIB_String_Initialize("//"));
    
    outfile = fopen("out.txt", "wb");
    
    now = time(NULL);
    pnow = localtime(&now);
    strftime(s, sizeof(s), "-%G/%m/%d %T 現在\n", pnow);
    fputs(s, outfile);
    
    for(files = 1; files < argc; files++){
        fp = fopen(argv[files], "rb");
        if(fp != NULL){
            //ファイルの読み込み
            fprintf(outfile, "**%s\n", CHNLIB_Environment_GetFilenameFromPath(argv[files]));
            root = CHNLIB_UIPArray_Initialize();
            for(;;){
                line = CHNLIB_ReadLine(fp);
                if(line == NULL){
                    break;
                }
                CHNLIB_UIPArray_GetSeparatedStringByUIPArray(&root, wordlist, line);
            }
            fclose(fp);
            
            i_max = CHNLIB_UIPArray_GetNumberOfDatas(root);
            recording = False;
            level = 0;
            for(i = 0; i < i_max; i++){
                switch(CHNLIB_UIPArray_GetData32ByIndex(root, i)){
                    case 1: //"{"
                        if(level == 0){
                            fprintf(outfile, "***%s\n", CHNLIB_String_GetReferencePointerOfCString(CHNLIB_UIPArray_GetPointerByIndex(root, i - 1)));
                            recording = True;
                        } else if(recording){
                            recording = False;
                            fprintf(outfile, "\n");
                        }
                        level++;
                        break;
                    case 2: //"}"
                        if(recording){
                            recording = False;
                            fprintf(outfile, "\n");
                        }
                        level--;
                        break;
                    case 3: //"//"
                        if(recording){
                            i++;
                            fprintf(outfile, "%s\n", CHNLIB_String_GetReferencePointerOfCString(CHNLIB_UIPArray_GetPointerByIndex(root, i)));
                        }
                        break;
                }
            }
            
            CHNLIB_UIPArray_FreeSelectedAll(&root);
        } else{
            printf("Can't open file [%s].\n", argv[files]);
        }
    }
    
    fclose(outfile);

    return 0;
}

