<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <html>
      <body>
        <H2>
          <xsl:value-of select="TEI.2/teiHeader/fileDesc/titleStmt/title"/>
        </H2>&#60;key type="表記" title="###.%%%"&#62;###.%%%&#60;/key&#62;
        <xsl:apply-templates select=".//text"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="div1">
&#60;H3 id="<xsl:value-of select="@n"/>"&#62;Book <xsl:value-of select="@n"/> [###.%%%.<xsl:value-of select="@n"/>]&#60;/H3&#62;&#60;key type="表記" title="###.%%%.<xsl:value-of select="@n"/>"&#62;###.%%%.<xsl:value-of select="@n"/>&#60;/key&#62;<xsl:apply-templates/></xsl:template>
  <xsl:template match="body/head">
&#60;H3&#62;<xsl:apply-templates/>&#60;/H3&#62;</xsl:template>

  <xsl:template match="div2">
&#60;H4 id="<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>"&#62;[###.%%%.<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>]&#60;/H3&#62;&#60;key type="表記" title="###.%%%.<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>"&#62;###.%%%.<xsl:value-of select="@n"/>&#60;/key&#62;<xsl:apply-templates/></xsl:template>

  <xsl:template match="quote">
      <xsl:choose>
          <xsl:when test="@rend = 'blockquote'">&#60;indent val="2"&#62;<xsl:apply-templates/>&#60;indent val="1"&#62;&#60;br&#62;</xsl:when>
          <xsl:when test="@rend = 'eleg'">&#60;/p&#62;&#60;indent val="2"&#62;<xsl:apply-templates/>&#60;indent val="1"&#62;&#60;p&#62;</xsl:when>
          <xsl:otherwise>&amp;#x201C;<xsl:apply-templates/>&amp;#x201D;</xsl:otherwise>
      </xsl:choose>
  </xsl:template>
  <xsl:template match="p">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="l">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="head">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="hi">
      <xsl:choose>
          <!-- rend = italics, smallcaps, sup, sub, underline -->
          <xsl:when test="@rend = 'italics'">&#60;i&#62;<xsl:apply-templates/>&#60;/i&#62;</xsl:when>
          <xsl:when test="@rend = 'sup'">&#60;sup&#62;<xsl:apply-templates/>&#60;/sup&#62;</xsl:when>
          <xsl:when test="@rend = 'sub'">&#60;sub&#62;<xsl:apply-templates/>&#60;/sub&#62;</xsl:when>
          <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
  </xsl:template>
  <xsl:template match="note">&#60;/p&#62;&#60;indent val="3"&#62;&#60;p&#62;[NOTE: <xsl:apply-templates/>]&#60;/p&#62;&#60;indent val="1"&#62;&#60;p&#62;</xsl:template>
  <xsl:template match="key">&#60;key type="<xsl:value-of select="@type"/>"&#62;<xsl:apply-templates/>&#60;/key&#62;</xsl:template>

  <xsl:template match="milestone">
    <xsl:choose>
        <xsl:when test="@unit = 'chapter'"><xsl:if test="@n != 1">&#60;/p&#62;</xsl:if>
            <xsl:choose>
            <xsl:when test="string-length(ancestor::div1/@n) != 0"><xsl:variable name="book" select="ancestor::div1/@n"/>
&#60;indent val="0"&#62;&#60;p id="<xsl:value-of select="$book"/>.<xsl:value-of select="@n"/>"&#62;&#60;dfn title="###.%%%.<xsl:value-of select="$book"/>.<xsl:value-of select="@n"/>"&#62;[###.%%%.<xsl:value-of select="$book"/>.<xsl:value-of select="@n"/>]&#60;/dfn&#62;&#60;/p&#62;&#60;indent val="1"&#62;&#60;p&#62;
            </xsl:when>
            <xsl:when test="string-length(ancestor::div1/@n) = 0">
&#60;indent val="0"&#62;&#60;p id="<xsl:value-of select="@n"/>"&#62;&#60;dfn title="###.%%%.<xsl:value-of select="@n"/>"&#62;[###.%%%.<xsl:value-of select="@n"/>]&#60;/dfn&#62;&#60;/p&#62;&#60;indent val="1"&#62;&#60;p&#62;
            </xsl:when>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="@unit = 'section'">
            <xsl:choose>
            <xsl:when test="string-length(ancestor::div1/@n) != 0 and string-length(ancestor::div2/@n) != 0">
&#60;br&#62;&#60;indent val="1"&#62;[<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="ancestor::div2/@n"/>.<xsl:value-of select="@n"/>]&amp;nbsp;</xsl:when>
            <xsl:when test="string-length(ancestor::milestone[unit='chapter']/@n) = 0">
&#60;br&#62;&#60;indent val="1"&#62;[<xsl:value-of select="@n"/>]&amp;nbsp;</xsl:when>
            </xsl:choose>
        </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="table">&#60;indent val="2"&#62;&#60;p&#62;&#60;table&#62;<xsl:apply-templates/>&#60;/table&#62;&#60;/p&#62;&#60;br&#62;&#60;br&#62;&#60;indent val="1"&#62;</xsl:template>
  <xsl:template match="table/head">&#60;caption&#62;<xsl:apply-templates/>&#60;/caption&#62;</xsl:template>
  <xsl:template match="row">&#60;tr&#62;<xsl:apply-templates/>&#60;/tr&#62;</xsl:template>
  <xsl:template match="cell">&#60;td&#62;<xsl:apply-templates/>&#60;/td&#62;</xsl:template>

  <xsl:template match="opener">&#60;indent val="2"&#62;<xsl:apply-templates/>&#60;indent val="1"&#62;</xsl:template>
  <xsl:template match="dateline">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="salute">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>

</xsl:stylesheet>
