%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating the passwd, group, and log Files</title>
@y
  <title>passwd, group, ログの各ファイル生成</title>
@z

@x
    <primary sortas="e-/etc/passwd">/etc/passwd</primary>
    <secondary>boot</secondary>
@y
    <primary sortas="e-/etc/passwd">/etc/passwd</primary>
    <secondary>ブート</secondary>
@z

@x
    <primary sortas="e-/etc/group">/etc/group</primary>
    <secondary>boot</secondary>
@y
    <primary sortas="e-/etc/group">/etc/group</primary>
    <secondary>ブート</secondary>
@z

@x
    <primary sortas="e-/var/log/btmp">/var/log/btmp</primary>
    <secondary>boot</secondary>
@y
    <primary sortas="e-/var/log/btmp">/var/log/btmp</primary>
    <secondary>ブート</secondary>
@z

@x
    <primary sortas="e-/var/log/lastlog">/var/log/lastlog</primary>
    <secondary>boot</secondary>
@y
    <primary sortas="e-/var/log/lastlog">/var/log/lastlog</primary>
    <secondary>ブート</secondary>
@z

@x
    <primary sortas="e-/var/log/wtmp">/var/log/wtmp</primary>
    <secondary>boot</secondary>
@y
    <primary sortas="e-/var/log/wtmp">/var/log/wtmp</primary>
    <secondary>ブート</secondary>
@z

@x
  <para os="a">In order for user <systemitem class="username">root</systemitem> to
  be able to login and for the name <quote>root</quote> to be recognized,
  there must be relevant entries in the <filename>/etc/passwd</filename>
  and <filename>/etc/group</filename> files.</para>
@y
  <para os="a">
  <systemitem class="username">root</systemitem> ユーザーが<quote>root</quote>として認識されログインできるようにするために
<filename>/etc/passwd</filename> ファイルと <filename>/etc/group</filename> ファイルに関連する項目を追加する必要があります。
  </para>
@z

@x
  <para>Create the <filename>${CLFS}/etc/passwd</filename> file by running
  the following command:</para>
@y
  <para>
  以下のコマンドを実行して <filename>${CLFS}/etc/passwd</filename> ファイルを生成します。
  </para>
@z

@x
  <para os="b">The actual password for <systemitem class="username">root</systemitem>
  (the <quote>::</quote> used here is just a placeholder and allows you to login
  with no password) will be set later.</para>
@y
  <para os="b">
  <systemitem class="username">root</systemitem> ユーザーに対する本当のパスワードは後に定めます。
  (<quote>::</quote>は単に場所を設けるために設定しているものです。)
  </para>
@z

@x
    <title>Additional users you may want to add if not already included:</title>
@y
    <title>上記以外で追加するユーザー候補</title>
@z

@x adm
        <para>Was used for programs that performed administrative tasks.</para>
@y
        <para>
        管理タスクを実行するプログラムが利用します。
        </para>
@z

@x lp
        <para>Used by programs for printing</para>
@y
        <para>
        印刷するプログラムが利用します。
        </para>
@z

@x mail
        <para>Often used by email programs</para>
@y
        <para>
        email プログラムが利用することがあります。
        </para>
@z

@x
        <para>Used by the D-Bus systemwide message bus</para>
@y
        <para>システム全般のメッセージバスである D-Bus 用のユーザー。</para>
@z

@x news
        <para>Often used for network news servers</para>
@y
        <para>
        ネットワークニュースサーバーが利用することがあります。
        </para>
@z

@x operator
        <para>Often used to allow system operators to access the system</para>
@y
        <para>
        システムオペレーターがシステムにアクセスすることを許可するために利用されます。
        </para>
@z

@x postmaster
        <para>Generally used as an account that receives all the information of troubles with the mail server</para>
@y
        <para>
        一般にメールサーバーにおいて発生する障害情報を受信するアカウントとして利用されます。
        </para>
@z

@x
  <para>Create the <filename>${CLFS}/etc/group</filename> file by running
  the following command:</para>
@y
  <para>
  以下のコマンドを実行して <filename>${CLFS}/etc/group</filename> ファイルを生成します。
  </para>
@z

@x
    <title>Additional groups you may want to add if not already included:</title>
@y
    <title>
    上記以外で追加するグループ候補:
    </title>
@z

@x console
        <para>This group has direct access to the console</para>
@y
        <para>
        コンソールに直接アクセスするグループです。
        </para>
@z

@x cdrw
        <para>This group is allowed to use the CDRW drive</para>
@y
        <para>
        CDRW ドライブの利用を許可するグループです。
        </para>
@z

@x
        <para>User for D-Bus</para>
@y
        <para>D-Bus 用ユーザー。</para>
@z

@x news
        <para>Used by Network News Servers</para>
@y
        <para>
        ネットワークニュースサーバーが利用します。
        </para>
@z

@x users
        <para>The default GID used by shadow for new users</para>
@y
        <para>
        shadow が利用する新ユーザーに割り当てられるデフォルトのGIDです。
        </para>
@z

@x nobody
        <para>This is used by NFS</para>
@y
        <para>
        NFS において利用されます。
        </para>
@z

@x
  <para os="e">The created groups are not part of any standard&mdash;they are
  groups decided on in part by the requirements of the Systemd configuration
  in the final system, and in part by common convention employed by a
  number of existing Linux distributions. The Linux Standard Base (LSB,
  available at
  <ulink url="http://www.linuxfoundation.org/collaborate/workgroups/lsb"/>)
  recommends only that, besides the group <quote>root</quote> with a Group ID
  (GID) of 0, a group <quote>bin</quote> with a GID of 1 be present. All other
  group names and GIDs can be chosen freely by the system administrator since
  well-written programs do not depend on GID numbers, but rather use the
  group's name.</para>
@y
  <para os="e">
  作成するグループは何かの標準に基づいたものではありません。
  一部は本章の Systemd の設定に必要となるものですし、一部は既存の Linux ディストリビューションが採用している慣用的なものです。
  Linux Standard Base (<ulink url="http://www.linuxfoundation.org/collaborate/workgroups/lsb"/> 参照) では
  <quote>root</quote> グループのグループID (GID) は 0、
  <quote>bin</quote> グループの GID は 1 を定めているにすぎません。
  他のグループとその GID はシステム管理者が自由に取り決めることができます。
  というのも通常のプログラムであれば GID の値に依存することはなく、あくまでグループ名を用いてプログラミングされているからです。
  </para>
@z

@x
  <para os="f">The <command>login</command>, <command>agetty</command>, and
  <command>init</command> programs (and others) use a number of log
  files to record information such as who was logged into the system and
  when. However, these programs will not write to the log files if they
  do not already exist. Initialize the log files and give them
  proper permissions:</para>
@y
  <para os="f">
  <command>login</command>、<command>agetty</command>、<command>init</command> といったプログラム (あるいは他のプログラム) は、システムに誰がいつログインしたかといった情報を多くのログファイルに記録します。
  しかしログファイルがあらかじめ存在していない場合は、ログファイルの出力が行われません。
  そこでそのようなログファイルを作成し、適切なパーミッションを与えます。
  </para>
@z

@x
  <para os="h">The <filename>/var/log/wtmp</filename>
  file records all logins and logouts. The
  <filename>/var/log/lastlog</filename> file records when
  each user last logged in. The <filename>/var/log/btmp</filename> file
  records the bad login attempts.</para>
@y
  <para os="h">
  <filename>/var/log/wtmp</filename> ファイルはすべてのログイン、ログアウトの情報を保持します。
  <filename>/var/log/lastlog</filename> ファイルは各ユーザーが最後にログインした情報を保持します。
  <filename>/var/log/btmp</filename> ファイルは不正なログイン情報を保持します。
  </para>
@z