%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>boot</secondary>
@y
    <secondary>ブート</secondary>
@z

@x
    <para>The Sysvinit package contains programs for controlling the startup,
    running, and shutdown of the system.</para>
@y
    <para>
    Sysvinit パッケージは、システムの起動、実行、シャットダウンを制御するプログラムを提供します。
    </para>
@z

@x
    <title>Installation of Sysvinit</title>
@y
    <title>&InstallationOf1;Sysvinit &InstallationOf2;</title>
@z

@x
    <para os="p1">Apply a patch to prevent installation of unneeded programs,
    and allow Sysvinit to be installed in
    <filename class="directory">/tools</filename>:</para>
@y
    <para os="p1">
    以下のパッチを適用して不要なプログラムはインストールしないようにします。
    また Sysvinit を <filename class="directory">/tools</filename> へインストールするようにします。
    </para>
@z

@x
    <para os ="c">Compile the package:</para>
@y
    <para os ="c">&CompileThePackage;</para>
@z

@x
   <para os="e">Install the package:</para>
@y
   <para os="e">&InstallThePackage;</para>
@z

@x
    <title>Configuring Sysvinit</title>
@y
    <title>&Configuring1;Sysvinit &Configuring2;</title>
@z

@x
      <secondary>boot, configuring</secondary>
@y
      <secondary>ブート, 設定</secondary>
@z

@x
    <para>Create a new file <filename>/tools/etc/inittab</filename> by running the
    following:</para>
@y
    <para>
    以下のコマンドを実行して <filename>/tools/etc/inittab</filename> を新たに生成します。
    </para>
@z

@x
    <para>The following command adds the standard virtual terminals to
    <filename>/tools/etc/inittab</filename>. If your system only has a serial
    console skip the following command:</para>
@y
    <para>
    以下のコマンドは <filename>/tools/etc/inittab</filename> に対して標準的な仮想端末を追加します。
    もしシリアルコンソールしか有していないシステムの場合は、このコマンド実行は省略してください。
    </para>
@z

@x
    <para>If your system has a serial console, run the following command to add
    the entry to <filename>/tools/etc/inittab</filename>.</para>
@y
    <para>
    シリアルコンソールを有している場合は、以下のコマンドを実行して <filename>/tools/etc/inittab</filename> へ項目追加します。
    </para>
@z

@x
   <para>Finally, add the end line to <filename>/tools/etc/inittab</filename>.</para>
@y
   <para>
   <filename>/tools/etc/inittab</filename> に最終行を加えます。
   </para>
@z

@x
    <para>The <parameter>-I '\033(K'</parameter> option tells
    <command>agetty</command> to send this escape sequence to the terminal
    before doing anything else. This escape sequence switches the console
    character set to a user-defined one, which can be modified by running
    the <command>setfont</command> program. Sending this
    escape sequence is necessary for people who use non-ISO 8859-1 screen
    fonts, but it does not affect native English speakers.</para>
@y
    <para>
    <parameter>-I '\033(K'</parameter> オプションは <command>agetty</command> が端末に対してまず初めにこのエスケープシーケンスを送るものです。
    これによって端末のキャラクターセットがユーザー指定のものに切り替わります。
    <command>setfont</command> プログラムを用いればキャラクターセットは変更できます。
    ISO 8859-1 以外のスクリーンフォントを利用するユーザーにとって、このエスケープシーケンスの送信は重要なものです。
    英語圏ユーザーにとっては不要なものです。
    </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-sysvinit" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-sysvinit" role=""/>&Details2;
    </para>
@z

%@x
%    <title>Contents of Sysvinit</title>
%@y
%    <title>&ContentsOf1;Sysvinit &ContentsOf2;</title>
%@z
%
%@x
%      <segtitle>Installed programs</segtitle>
%@y
%      <segtitle>&InstalledProgram;</segtitle>
%@z
%
%@x
%        <seg>bootlogd, fstab-decode, halt, init, killall5,
%        poweroff (link to halt), reboot (link to halt), runlevel,
%        shutdown, and telinit (link to init)</seg>
%@y
%        <seg>bootlogd, fstab-decode, halt, init, killall5,
%        poweroff (&LinkTo1;halt&LinkTo2;), reboot (&LinkTo1;halt&LinkTo2;), runlevel,
%        shutdown, telinit (&LinkTo1;init&LinkTo2;)</seg>
%@z
%
%@x
%      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
%@y
%      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
%@z
%
%@x bootlogd
%          <para>Logs boot messages to a log file</para>
%@y
%          <para>
%          ブート時のメッセージをログファイルに出力します。
%          </para>
%@z
%
%@x fstab-decode
%          <para>Runs a command with fstab-encoded arguments</para>
%@y
%          <para>
%          fstab 形式の (fstab-encoded の) 引数とともにコマンドを実行します。
%          </para>
%@z
%
%@x halt
%          <para>Normally invokes <command>shutdown</command> with the
%          <parameter>-h</parameter> option, except when already in run-level 0,
%          then it tells the kernel to halt the system; it notes in the
%          file <filename>/var/log/wtmp</filename> that the system is being
%          brought down</para>
%@y
%          <para>
%          ランレベルが既に 0 ではない通常の起動状態の場合に <command>shutdown</command> をオプション <parameter>-h </parameter> をつけて実行します。
%          そしてカーネルに対してシステム停止を指示します。
%          システムが停止される状況は <filename>/var/log/wtmp</filename> ファイルに記録されます。
%          </para>
%@z
%
%@x init
%          <para>The first process to be started when the kernel has initialized
%          the hardware which takes over the boot process and starts all the
%          proceses it is instructed to</para>
%@y
%          <para>
%          カーネルがハードウェアを初期化した後に、最初に起動するプロセスです。
%          ブート処理がこのプロセスに引き継がれ、指示されたプロセスをすべて起動していきます。
%          </para>
%@z
%
%@x killall5
%          <para>Sends a signal to all processes, except the processes in its own
%          session so it will not kill the shell running the script that called
%          it</para>
%@y
%          <para>
%          プロセスすべてに対してシグナルを送信します。
%          ただし自分のセッション内の起動プロセスは除きます。
%          つまり本コマンドを実行したシェルは停止しません。
%          </para>
%@z
%
%@x poweroff
%          <para>Tells the kernel to halt the system and switch off the computer
%          (see <command>halt</command>)</para>
%@y
%          <para>
%          カーネルに対してシステムの停止を指示し、コンピューターの電源を切ります。(<command>halt</command> を参照してください。)
%          </para>
%@z
%
%@x reboot
%          <para>Tells the kernel to reboot the system (see
%          <command>halt</command>)</para>
%@y
%          <para>
%          カーネルに対してシステムの再起動を指示します。(<command>halt</command> を参照してください。)
%          </para>
%@z
%
%@x runlevel
%          <para>Reports the previous and the current run-level, as noted in
%          the last run-level record in <filename>/run/utmp</filename></para>
%@y
%          <para>
%          現在のランレベルと直前のランレベルを表示します。
%          最新のランレベルは <filename>/run/utmp</filename> ファイルに記録されています。
%          </para>
%@z
%
%@x shutdown
%          <para>Brings the system down in a secure way, signaling all processes
%          and notifying all logged-in users</para>
%@y
%          <para>
%          システムの終了を安全に行います。
%          その際にはプロセスすべてへのシグナル送信を行い、ログインユーザーへの通知も行います。
%          </para>
%@z
%
%@x telinit
%          <para>Tells <command>init</command> which run-level to change to</para>
%@y
%          <para>
%          <command>init</command> に対してランレベルの変更を指示します。
%          </para>
%@z