%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Adjusting the Toolchain</title>
@y
  <title>ツールチェーンの調整</title>
@z

@x
  <para os="a">Now we adjust GCC's specs so that they point to the new
  dynamic linker. A <command>perl</command> command accomplishes this:</para>
@y
  <para os="a">
  GCC スペックファイルを修正し、新しいダイナミックリンカーを指し示すようにします。
  以下の <command>perl</command> によりこれを実現します。
  </para>
@z

@x
  <para os="d">The <command>perl</command> command above makes 2
  modifications to GCC's specs: it removes <quote>/tools</quote> from the
  pathname to the dynamic linker, and adds <quote>/usr/lib/</quote> to the
  startfile_prefix_spec. It is a good idea to visually inspect the
  <filename>specs</filename> file, and compare with the output of
  <command>gcc -dumpspecs</command>, to verify that
  the intended changes were actually made.</para>
@y
  <para os="d">
  上記の <command>perl</command> コマンドは GCC のスペックファイルに二種類の修正を行うものです。
  一つはダイナミックリンカーのパス名から <quote>/tools</quote> を取り除きます。
  もう一つは startfile_prefix_spec に<quote>/usr/lib/</quote>を加えます。
  実際に <filename>specs</filename> ファイルの内容を覗いてみてください。
  <command>gcc -dumpspecs</command> の出力結果と比較して、意図した修正が行われていることを確認してください。
  </para>
@z

@x
    <para os="f">It is imperative at this point to stop and ensure that
    the basic functions (compiling and linking) of the adjusted toolchain
    are working as expected. To do this, perform a sanity
    check:</para>
@y
    <para os="f">
    この時点において、基本的な機能 (コンパイルやリンクなど) が正しく動作していることを確認する必要があります。
    これを行うために以下の健全性検査を実行します。
    </para>
@z

@x
    <para os="h">If everything is working correctly, there should be no errors,
    and the output of the last command will be:</para>
@y
    <para os="h">
    問題なく動作した場合はエラーがなかったということで、最後のコマンドから出力される結果は以下のようになるはずです。
    </para>
@z

@x
    <para os="j">Note that <filename class="directory">/lib</filename> is now
    the prefix of our dynamic linker.</para>
@y
    <para os="j">
    ここでダイナミックリンカーのディレクトリが <filename
    class="directory">/lib</filename> であることを確認してください。
    </para>
@z

@x
    <para os="k">If the output does not appear as shown above or is not received
    at all, then something is seriously wrong. Investigate and retrace the
    steps to find out where the problem is and correct it. The most likely
    reason is that something went wrong with the specs file amendment
    above. Any issues will need to be resolved before continuing on with
    the process.</para>
@y
    <para os="k">
    出力結果が上と異なっていたり、出力が全く得られなかったりした場合は、何かが根本的に間違っているということです。
    どこに問題があるのか調査、再試行を行って解消してください。
    最もありがちな理由は、スペックファイルの修正を誤っていることです。
    問題を残したままこの先には進まないでください。
    </para>
@z

@x
    <para os="l">Once everything is working correctly, clean up the test
    files:</para>
@y
    <para os="l">
    すべてが正しく動作したら、テストに用いたファイルを削除します。
    </para>
@z