%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>How to Build a CLFS System</title>
@y
  <title>CLFS をどうやって作るか</title>
@z

@x
  <para>The CLFS system will be built by using a previously installed
  Unix system or Linux distribution (such as Debian, Fedora, openSUSE,
  or Ubuntu). This existing system (the host) will be used as a starting
  point to provide necessary programs, including a compiler, linker, and shell,
  to build the new system. Select the <quote>development</quote> option
  during the distribution installation to be able to access these
  tools.</para>
@y
  <para>
  CLFS システムは、既にインストールされている Unix システムや Linux ディストリビューション (Debian、Fedora、openSUSE、Ubuntu など) を利用して構築していきます。
  この既存のシステム（ホスト）は、CLFS 構築のためにさまざまなプログラム類を利用する基盤となります。
  プログラム類とはコンパイラー、リンカー、シェルなどです。
  したがってそのディストリビューションのインストール時には "開発 (development)" オプションを選択し、それらのプログラム類が利用できるようにしておく必要があります。
  </para>
@z

@x
  <para>As an alternative to installing an entire separate distribution onto
  your machine, you may wish to use a livecd. Most distributions provide
  a livecd, which provides an environment to which you can add the required
  tools onto, allowing you to successfully follow the instructions in this
  book. Remember that if you reboot the livecd you will need to reconfigure
  the host environment before continuing with your build.</para>
@y
  <para>
  コンピューター内にインストールされているディストリビューションを利用するのではなく LiveCD を利用することもできます。
  ディストリビューションにはたいてい LiveCD があります。
  これを利用して必要なツールを導入した上で、本書に示す手順を進めていくことができます。
  ただし LiveCD を再起動した場合には、ビルド作業を再開する前に必ずホスト環境を再整備しなければならない点には注意してください。
  </para>
@z

@x
  <para><xref linkend="chapter-partitioning"/> of this book describes how
  to create a new Linux native partition and file system, the place
  where the new CLFS system will be compiled and installed. <xref
  linkend="chapter-getting-materials"/> explains which packages and
  patches need to be downloaded to build a CLFS system and how to store
  them on the new file system. <xref linkend="chapter-final-preps"/>
  discusses the setup for an appropriate working environment. Please read
  <xref linkend="chapter-final-preps"/> carefully as it explains several
  important issues the developer should be aware of before beginning to
  work through <xref linkend="chapter-cross-tools"/> and
  beyond.</para>
@y
  <para>
  <xref linkend="chapter-partitioning"/>では、新しく構築する Linux のためのパーティションとファイルシステムの生成方法について説明します。
  そのパーティション上にて CLFS システムをコンパイルしインストールします。
  <xref linkend="chapter-getting-materials"/>では CLFS 構築に必要となるパッケージとパッチについて説明します。
  これらをダウンロードして新たなファイルシステム内に保存します。
  <xref linkend="chapter-final-preps"/>は作業環境の準備について述べています。
  この章では重要な説明を行っていますので、<xref linkend="chapter-cross-tools"/>以降に進む前に是非注意して読んでください。
  </para>
@z

@x
  <para><xref linkend="chapter-cross-tools"/> explains the installation of
  cross-compile tools which will be built on the host but be able to compile
  programs that run on the target machine. These cross-compile tools will
  be used to create a temporary, minimal system that will be the basis for
  building the final CLFS system. Some of these packages are needed to resolve
  circular dependencies&mdash;for example, to compile a compiler, you need a
  compiler.</para>
@y
  <para>
  <xref linkend="chapter-cross-tools"/> ではクロスコンパイルツールのインストール方法を説明します。
  これはホストシステム上に生成していきますが、ターゲットマシンにて動作するプログラムをコンパイルできるものです。
  このクロスコンパイルツールにより一時システムを構築し、これをベースとして最終的な CLFS システムを作り上げます。
  パッケージの中には自分自身を循環的に必要とするような依存関係を持つものがあります。
  例えばコンパイラーをコンパイルするためにはコンパイラーが必要となります。
  </para>
@z

@x
  <para>The process of building cross-compile tools first involves building and
  installing all the necessary tools to create a build system for the target
  machine. With these cross-compiled tools, we eliminate any
  dependencies on the toolchain from our host distro.</para>
@y
  <para>
  クロスコンパイルツールの構築作業はまず初めに、ターゲットマシン用のビルドシステムを作るために必要となるツール類をビルドしインストールします。
  その作業ではツールチェーン内にホストシステムへの依存がないようにしていきます。
  </para>
@z

@x
  <para>After we build our <quote>Cross-Tools</quote>, we start building
  a very minimal working system in
  <filename class="directory">/tools</filename>, using the cross-toolchain in
  <filename class="directory">/cross-tools</filename>. Once the temporary
  system is finished, we perform a few additional tasks to prepare to
  enter this temporary build environment, either by booting or chrooting into
  it. For more details about the difference between these methods, see
  <xref linkend="ch-temp-system-choose"/>.</para>
@y
  <para>
  "クロスツール" を作り上げた次には <filename
  class="directory">/tools</filename> ディレクトリ内に必要最小限の一時システムを構築します。
  これは <filename class="directory">/cross-tools</filename> ディレクトリ内にあるクロスツールチェーンを用いて行います。
  一時システムが出来上がったら多少の作業を行った後に、再起動を行うか chroot を行うかのいずれかを通じて一時システムのビルド環境へ入ります。
  再起動か chroot かの違いについての詳細は <xref linkend="ch-temp-system-choose"/> を参照してください。
  </para>
@z

@x
  <para>In <xref linkend="chapter-building-system"/>, after having booted
  or chrooted into the temporary build environment, the full CLFS system is
  built.</para>
@y
  <para>
  <xref linkend="chapter-building-system"/> では、再起動または chroot により一時的なビルド環境に入り完全な CLFS システムを構築します。
  </para>
@z

@x
  <para>To finish the installation, several configuration files are created in
  <xref linkend="chapter-system-config"/>, and the kernel and boot loader are
  set up in <xref linkend="chapter-bootable"/>.
  <xref linkend="chapter-finalizing"/>
  contains information on furthering the CLFS experience beyond this book.
  After the steps in this book have been implemented, the computer will be
  ready to reboot into the new CLFS system.</para>
@y
  <para>
  インストールの仕上げとして<xref linkend="chapter-system-config"/>にてベースシステムの設定を行い、<xref
  linkend="chapter-bootable"/>にてカーネルとブートローダーを設定します。
  <xref linkend="chapter-finalizing"/>では CLFS システム構築経験を踏まえて、その先に進むための情報を示します。
  本書に示す作業をすべて実施すれば、新たな CLFS システムを起動することが出来ます。
  </para>
@z

@x
  <para>This is the process in a nutshell. Detailed information on each
  step is discussed in the following chapters and package descriptions.
  Items that may seem complicated will be clarified, and everything will
  fall into place as the reader embarks on the CLFS adventure.</para>
@y
  <para>
  上はごく簡単な説明にすぎません。
  各作業の詳細はこれ以降の章やパッケージの説明を参照してください。
  内容が難しいと思っていても、それは徐々に理解していけるはずです。
  読者の皆さんには、是非 CLFS アドベンチャーに挑んで頂きたいと思います。
  </para>
@z