%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Networking Configuration with Systemd-networkd</title>
@y
  <title>Systemd によるネットワーク設定</title>
@z

@x
    <title>Network Interface Configuration</title>
@y
    <title>ネットワークインターフェースの設定</title>
@z

@x
    <note><para>Udev may assign random Network Card Interface names
    for some network cards such as enp2s1. If you are not sure what
    your Network Card Interface name is, you can always run
    <command>ip l</command> after you have booted your system. It is important
    that the <envar>Name</envar> variable in
    <filename>/etc/systemd/network</filename> contain the correct Network Card
    Interface name (e.g. <envar>Name=enp2s1</envar> or
    <envar>Name=eth0</envar>) or systemd will fail to bring
    up your network interface.</para></note>
@y
    <note><para>
    Udev はネットワークカードによっては、enp2s1 などのようなランダムなネットワークカードインターフェース名を割り当てることがあります。
    インタフェース名がよく分からない場合は、システム起動直後に <command>ip l</command> を実行すれば確認することができます。
    <filename>/etc/systemd/network</filename> ファイル内の <envar>Name</envar> 変数はネットワークカードインターフェースを示す正しい名称 (つまり <filename>Name=enp2s1</filename> や <filename>Name=eth0</filename>) としなければなりません。
    これを行っていない場合には、systemd によるネットワークインターフェースの初期化がなされないことになります。
    </para></note>
@z

@x
      <title>Static Network Interface Configuration</title>
@y
      <title>ネットワークインターフェースのスタティック設定</title>
@z

@x
      <para><command>systemd-networkd</command> uses
      <filename>/etc/system/network</filename> for configuration files. Refer
      to systemd.network(5) and systemd.netdev(5). Configure a network
      interface with a config file. Adjust Name= as required:</para>
@y
      <para>
      <command>systemd-networkd</command> は設定ファイルとして <filename>/etc/system/network</filename> を利用します。
      詳細は systemd.network(5) や systemd.netdev(5) を確認してください。
      設定ファイルによりネットワークインターフェースを設定します。
      Name= の部分は適切に書き換えてください。
      </para>
@z

@x
      <para os="var-ob">The values of these variables must be changed in every
      file to match the proper setup.</para>
@y
      <para os="var-ob">
      各変数の値は、このような設定ファイルの個々において適切なものに書き換えてください。
      </para>
@z

@x
      <para os="var-i">The <envar>Name</envar> variable defines the interface
      name, for example, eth0. It is required for all network device
      configuration files.</para>
@y
      <para os="var-i">
      変数 <envar>Name</envar> はインターフェース名を定義します。
      例えば eth0 などです。
      ネットワークデバイスの設定ファイルにはこれを必ず記述します。
      </para>
@z

@x
      <para>The <envar>Gateway</envar> variable should contain the default
      gateway IP address, if one is present. If not, then comment out the
      variable entirely.</para>
@y
      <para>
      変数 <envar>Gateway</envar> はデフォルトゲートウェイが存在する場合に、その IP アドレスを設定します。
      存在しない場合はこの変数設定全体をコメントにしてください。
      </para>
@z

@x
      <para>For more information see the <command>systemd.netdev</command> man page.</para>
@y
      <para>
      詳しくは <command>systemd.netdev</command> の man ページを参照してください。
      </para>
@z

@x
      <title>Connecting to a network with DHCP</title>
@y
      <title>DHCP への接続設定</title>
@z

@x
    <para><command>systemd-networkd</command> uses
    <filename>/etc/systemd/network</filename> for configuration files. Refer
    to <filename>systemd.network(5)</filename> and
    <filename>systemd.netdev(5)</filename>. Configure a network interface
    with a config file. Adjust Name= as required:</para>
@y
    <para>
    <command>systemd-networkd</command> は設定ファイルとして <filename>/etc/system/network</filename> を利用します。
    詳細は systemd.network(5) や systemd.netdev(5) を確認してください。
    設定ファイルによりネットワークインターフェースを設定します。
    Name= の部分は適切に書き換えてください。
    </para>
@z

@x
    <para><command>systemd-networkd</command> will automatically configure
    <filename>/run/systemd/network/resolv.conf</filename> when using DHCP.
    If you did not manually create <filename>/etc/resolv.conf</filename>,
    create a symlink:</para>
@y
    <para>
    DHCP の利用時は <command>systemd-networkd</command> は自動的に <filename>/run/systemd/network/resolv.conf</filename> を設定します。
    <filename>/etc/resolv.conf</filename> を手動で生成しないのであれば、以下によりシンボリックリンクを生成します。
    </para>
@z

@x
    <title>Using Timesyncd</title>
@y
    <title>Timesyncd の利用</title>
@z

@x
    <para>Systemd includes a simple NTP client daemon,
    <command>systemd-timesyncd</command>, though it is disabled by
    default. If you want to enable it, you will first need to add a required
    user and group:</para>
@y
    <para>
    Systemd には簡易な NTP クライアントデーモン <command>systemd-timesyncd</command> があります。
    ただしデフォルトではこれが無効化されています。
    これを有効にするには、まず必要となるユーザーとグループを作成しておきます。
    </para>
@z

@x
    <para>Then, actually enable <command>systemd-timesyncd</command> so that
    it will run on system boot:</para>
@y
    <para>
    そして <command>systemd-timesyncd</command> を用いて、システム起動時に有効となるようにします。
    </para>
@z

@x
    <para>You can configure <command>systemd-timesyncd</command> by editing
    <filename>/etc/systemd/timesyncd.conf</filename>.</para>
@y
    <para>
    <filename>/etc/systemd/timesyncd.conf</filename> ファイルを編集すれば <command>systemd-timesyncd</command> を設定することもできます。
    </para>
@z

@x
  <para>Continue to <xref linkend="chapter-bootable"/>.</para>
@y
  <para>
  次は <xref linkend="chapter-bootable"/> に進んでください。
  </para>
@z