%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Setting Up Locale Information</title>
@y
  <title>ロケール情報の設定</title>
@z

@x
  <para>The instructions below explain how to add some environment variables
  necessary for native language support to the base
  <filename>/etc/profile</filename> created in the previous section. Setting
  these variables properly results in:</para>
@y
  <para>
  ここに示す手順では、前節で生成したシステムベースの設定ファイル <filename>/etc/profile</filename> に対して、自言語サポートのための環境変数を設定します。
  適切に定めることにより以下の内容が定められます。
  </para>
@z

@x
      <para>The output of programs translated into the native language</para>
@y
      <para>
      プログラムの出力結果を指定した言語で得ることができます。
      </para>
@z

@x
      <para>Correct classification of characters into letters, digits and
      other classes. This is necessary for <command>bash</command> to
      properly accept non-ASCII characters in command lines in non-English
      locales</para>
@y
      <para>
      キャラクターを英字、数字、その他のクラスに分類します。
      この設定は、英語以外のロケールにおいて、コマンドラインに非アスキー文字が入力された場合に <command>bash</command> が正しく入力を受け付けるために必要となります。
      </para>
@z

@x
      <para>The correct alphabetical sorting order for the country</para>
@y
      <para>
      各国ごとに正しくアルファベット順が並ぶようにします。
      </para>
@z

@x
      <para>Appropriate default paper size</para>
@y
      <para>
      適切なデフォルト用紙サイズを設定します。
      </para>
@z

@x
      <para>Correct formatting of monetary, time, and date values</para>
@y
      <para>
      通貨、日付、時刻を正しい書式で出力するように設定します。
      </para>
@z

@x
  <para>Replace <replaceable>[ll]</replaceable> below with the
  two-letter code for the desired language (e.g., <quote>en</quote>) and
  <replaceable>[CC]</replaceable> with the two-letter code for the
  appropriate country (e.g., <quote>GB</quote>).
  <replaceable>[charmap]</replaceable> should be replaced with the
  canonical charmap for your chosen locale.</para>
@y
  <para>
  以下において <replaceable>[ll]</replaceable> と示しているものは、言語を表す２文字の英字 (例えば <quote>en</quote>) に、また <replaceable>[CC]</replaceable> は、国を表す２文字の英字 (例えば <quote>GB</quote>) にそれぞれ置き換えてください。
  <replaceable>[charmap]</replaceable> は、選択したロケールに対応したキャラクターマップ (charmap) に置き換えてください。
  </para>
@z

@x
  <para>The list of all locales supported by Glibc can be obtained by running
  the following command:</para>
@y
  <para>
  以下のコマンドを実行すれば Glibc が取り扱うロケールを一覧で見ることができます。
  </para>
@z

@x
  <para>Locales can have a number of synonyms, e.g. <quote>ISO-8859-1</quote>
  is also referred to as <quote>iso8859-1</quote> and <quote>iso88591</quote>.
  Some applications cannot handle the various synonyms correctly, so it is
  safest to choose the canonical name for a particular locale. To determine
  the canonical name, run the following command, where <replaceable>[locale
  name]</replaceable> is the output given by <command>locale -a</command> for
  your preferred locale (<quote>en_US.utf8</quote> in our example).</para>
@y
  <para>
  ロケールには類似表現がいくつもあります。
  例えば<quote>ISO-8859-1</quote>は<quote>iso8859-1</quote>や<quote>iso88591</quote>として記述することもできます。
  ただしアプリケーションによってはエイリアスを正しく取り扱うことができないものがあります。
  そこでロケールに対する正規の名称を選ぶのが最も無難です。
  正規の名称は以下のコマンドを実行すれば分かります。
  ここで <replaceable>[locale name]</replaceable> は <command>locale -a</command> コマンドの出力から得られたロケールを指定します。
  (本書の例では<quote>en_GB.iso88591</quote>としています。)
  </para>
@z

@x
  <para>For the <quote>en_US.utf8</quote> locale, the above command
  will print:</para>
@y
  <para>
  <quote>en_US.utf8</quote>ロケールの場合、上のコマンドの出力は以下となります。
  </para>
@z

@x
  <para>This results in a final locale setting of <quote>en_US.UTF-8</quote>.
  It is important that the locale found using the heuristic above is tested prior
  to it being added to the Bash startup files:</para>
@y
  <para>
  出力された結果が<quote>en_US.UTF-8</quote>に対するロケール設定として用いるべきものです。
  こうして探し出したロケールは動作確認しておくことが重要です。
  Bash 起動時の設定ファイルに記述するのはその後です。
  </para>
@z

@x
  <para>The above commands should print the language name, the character
  encoding used by the locale, the local currency, and the prefix to dial
  before the telephone number in order to get into the country. If any of the
  commands above fail with a message similar to the one shown below, this means
  that your locale was either not installed in Chapter 10 or is not supported by
  the default installation of Glibc.</para>
@y
  <para>
  上のコマンドを実行すると、言語名やロケールに応じたキャラクターエンコーディングが出力されます。
  また通貨や各国ごとの国際電話番号プレフィックスも出力されます。
  コマンドを実行した際に以下のようなメッセージが表示されたら、第10章にてロケールをインストールしていないか、あるいはそのロケールが Glibc のデフォルトのインストールではサポートされていないかのいずれかです。
  </para>
@z

@x
  <para>If this happens, you should either install the desired locale using
  the <command>localedef</command> command, or consider choosing a different
  locale. Further instructions assume that there are no such error messages
  from Glibc.</para>
@y
  <para>
  このエラーが発生したら <command>localedef</command> コマンドを使って、目的とするロケールをインストールするか、別のロケールを選ぶ必要があります。
  これ以降の説明では Glibc がこのようなエラーを生成していないことを前提に話を進めます。
  </para>
@z

@x
  <para>Some packages beyond CLFS may also lack support for your chosen locale.
  One example is the X library (part of the X Window System), which outputs
  the following error message:</para>
@y
  <para>
  CLFS に含めていないパッケージでは、指定したロケールをサポートしていないものもあります。
  例えば X ライブラリ (X ウィンドウシステムの一部) では以下のようなメッセージを出力します。
  </para>
@z

@x
  <para>Sometimes it is possible to fix this by removing the charmap part of
  the locale specification, as long as that does not change the character map
  that Glibc associates with the locale (this can be checked by running the
  <command>locale charmap</command> command in both locales). For example,
  one would have to change &quot;de_DE.ISO-8859-15@euro&quot; to
  &quot;de_DE@euro&quot; in order to get this locale recognized by Xlib.</para>
@y
  <para>
  この症状は、ロケール設定の中からキャラクターマップの定義部分を削除することで回避できる場合があります。
  ただしそのキャラクターマップは Glibc がロケールに関連づいていない場合に限ります。
  (関連づいているかどうかは <command>locale charmap</command> を実行して確認することができます。)
  例えば Xlib においてロケールを正常に認識させるためには &quot;de_DE.ISO-8859-15@euro&quot; を &quot;de_DE@euro&quot; に変更するのがよいかもしれません。
  </para>
@z

@x
  <para>Other packages can also function incorrectly (but may not necessarily
  display any error messages) if the locale name does not meet their expectations.
  In those cases, investigating how other Linux distributions support your locale
  might provide some useful information.</para>
@y
  <para>
  これ以外のパッケージでも、パッケージが求めるものとは異なるロケール設定がなされた場合に、適切に処理されないケースがあります。
  (そして必ずしもエラーメッセージが表示されない場合もあります。) 
  そういったケースでは、利用している Linux ディストリビューションがどのようにロケール設定をサポートしているかを調べてみると、有用な情報が得られるかもしれません。
  </para>
@z

@x
  <para>Once the proper locale settings have been determined, add them to the
  <filename>/etc/profile</filename> file:</para>
@y
  <para>
  適切なロケール設定が決まったら <filename>/etc/profile</filename> ファイルに加えます。
  </para>
@z

@x
  <para>Setting the keyboard layout, screen font, and locale-related
  environment variables are the only internationalization steps needed to
  support locales that use ordinary single-byte encodings and left-to-right
  writing direction. UTF-8 has been tested on the English, French, German,
  Italian, and Spanish locales. All other locales are untested. If you discover
  issues with any other locale please open a ticket in our Trac system.</para>
@y
  <para>
  キーボードレイアウト、スクリーンフォント、ロケール関連といった各種環境変数を設定するのは国際化に関する作業ステップです。
  これはごく普通のシングルバイトのエンコーディングや左から右に記述する言語のロケールをサポートするのみです。
  UTF-8 に関しては英語、フランス語、ドイツ語、イタリア語、スペイン語の各ロケールに対してテスト済みですが、これ以外については未確認です。
  ロケールに関しての問題を発見した際はぜひ、我々が運営する Trac システムにチケットとしてあげてください。
  </para>
@z

@x
  <para>Some locales need additional programs and support. CLFS will not be
  supporting these locales in the book. We welcome the support for these other
  locales via <ulink url="&cblfs-root;"/>.</para>
@y
  <para>
  ロケールによってはさらにプログラムや追加設定を要するものもあります。
  CLFS ではそういったロケールは取り扱いません。
  そのロケールについての情報はぜひ <ulink url="&cblfs-root;"/> に寄せてください。
  </para>
@z