%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <title>Installation of Glibc</title>
@y
    <title>&InstallationOf1;Glibc&InstallationOf2;</title>
@z

@x
        <para>The <emphasis>nptl/tst-clock2</emphasis>,
        <emphasis>nptl/tst-attr3</emphasis>,
        <emphasis>tst/tst-cputimer1</emphasis>, and
        <emphasis>rt/tst-cpuclock2</emphasis>
        tests have been known to fail.  The
        reason is not completely understood, but indications are that minor
        timing issues can trigger these failures.</para>
@y
        <para>
        <emphasis>nptl/tst-clock2</emphasis>,
        <emphasis>nptl/tst-attr3</emphasis>,
        <emphasis>tst/tst-cputimer1</emphasis>,
        <emphasis>rt/tst-cpuclock2</emphasis> のテストは失敗することが知られています。
        失敗の理由は明確ではありません。
        ただ処理速度が原因してそれらが発生すると思われます。
        </para>
@z

@x
        <para>The <emphasis>math</emphasis> tests, at least on i686, fail in
        the <emphasis>test-double</emphasis> and <emphasis>test-idouble</emphasis>
        tests with gcc-&gcc-version;
        . These two failures in the math tests appear to be harmless.
        The math tests may also fail on systems where the CPU is not a relatively
        new genuine Intel or authentic AMD. Certain optimization settings are
        also known to be a factor here.</para>
@y
        <para>
        <emphasis>math</emphasis> テストの中で <emphasis>test-double</emphasis> と <emphasis>test-idouble</emphasis> は gcc-&gcc-version; を用いてテストすると、特に i686 上において失敗します。
        この 2つの失敗は特に問題はありません。
        また math テストは、純正 Intel プロセッサーや AMD プロセッサーが最新のものではない場合に失敗することがあります。
        特定の最適化設定が原因で失敗するものもあります。
        </para>
@z

@x
        <para>If you have mounted the CLFS partition with the
        <parameter>noatime</parameter> option, the <emphasis>atime</emphasis> test
        will fail. As mentioned in <xref linkend="ch-partitioning-mounting"/>,
        do not use the <parameter>noatime</parameter> option while building
        CLFS.</para>
@y
        <para>
        CLFS パーティションを <parameter>noatime</parameter> オプションを用いてマウントしている場合 <emphasis>atime</emphasis> テストが失敗します。
        <xref linkend="ch-partitioning-mounting"/> で説明しているように、CLFS のビルド中は <parameter>noatime</parameter> オプションを使わないようにしてください。
        </para>
@z

@x
        <para>When running on older and slower hardware, some tests
        can fail because of test timeouts being exceeded.
        Modifying the make check command to set a TIMEOUTFACTOR is reported to
        help eliminate these errors (e.g. <command>TIMEOUTFACTOR=16
        make -k check</command>).</para>
@y
        <para>
        旧式のハードウェアや性能の低いハードウェア、あるいは負荷の高いシステムにおいてテストを行うと、処理時間をオーバーしてタイムアウトが発生しテストが失敗します。
        make check コマンドにて TIMEOUTFACTOR をセットするものに修正すれば、それらのエラーは回避できると報告されています。
        (例： <command>TIMEOUTFACTOR=16 make -k check</command>)
        </para>
@z

@x
        <para>posix/tst-getaddrinfo4 will always fail due to not having a network
        connection when the test is run.</para>
@y
        <para>
        posix/tst-getaddrinfo4 は、テスト実行時にネットワークに接続されていないため失敗します。
        </para>
@z