%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Audience</title>
@y
  <title>対象読者</title>
@z

@x
  <para>There are many reasons why somebody would want to read this book.
  The principal reason is to install a Linux system from the  source code.
  A question many people raise is, <quote>why go through all the hassle of
  manually building a Linux system from scratch when you can just download
  and install an existing one?</quote> That is a good question and is the
  impetus for this section of the book.</para>
@y
  <para>
  本書を読む理由はさまざまにあると思います。
  その第一は Linux システムをソースコードから作り上げる点です。
  よく挙がってくる質問として以下があります。
  <quote>既にある Linux をダウンロードしてインストールすれば良いのに、どうして苦労してまで手作業で Linux を構築しようとするのか。</quote>
  良い質問です。
  本節を示す理由がそこにあります。
  </para>
@z

@x
  <para>One important reason for the existence of CLFS is to help people
  understand how a Linux system works.  Building an CLFS system helps
  demonstrate what makes Linux tick, and how things work together and
  depend on each other. One of the best things this learning experience
  provides is the ability to customize Linux to your own
  tastes and needs.</para>
@y
  <para>
  CLFS を提供する最大の理由は Linux システムがどのようにして動作しているのか、これを学ぶためのお手伝いをすることです。
  CLFS システムを構築してみれば、さまざまなものが連携し依存しながら動作している様子を知ることができます。
  そうした経験をした人であれば Linux システムを自分の望む形に作りかえる手法も身につけることができます。
  </para>
@z

@x
  <para>A key benefit of CLFS is that it allows users to have more control
  over their system without any reliance on a Linux implementation designed
  by someone else.  With CLFS, <emphasis>you</emphasis> are in the driver's
  seat and dictate every aspect of the system, such as the directory layout
  and bootscript setup. You also dictate where, why, and how programs are
  installed.</para>
@y
  <para>
  CLFS の重要な利点として、他の Linux システムに依存することなくシステムをより適切に制御できる点が挙げられます。
  CLFS システムではあなたが運転台に立って、システムのあらゆる側面への指示を下していきます。
  ディレクトリレイアウトであったりブートスクリプトの設定であったり。
  そして各種プログラムをどこへ何のためにどうやってインストールするかも思いのままです。
  </para>
@z

@x
  <para>Another benefit of CLFS is the ability to create a very compact
  Linux system. When installing a regular distribution, one is often forced
  to include several programs which are probably never used. These programs
  waste disk space or CPU cycles.  It is not difficult to build an CLFS
  system of less than 100 megabytes (MB), which is substantially smaller
  than the majority of existing installations.  Does this still sound like a
  lot of space? A few of us have been working on creating a very small
  embedded CLFS system. We successfully built a system that was specialized
  to run the Apache web server with approximately 8MB of disk space used.
  Further stripping could bring this down to 5 MB or less. Try that with a
  regular distribution! This is only one of the many benefits of designing
  your own Linux implementation.</para>
@y
  <para>
  さらに非常にコンパクトな Linux システムを作る方法も身につけられます。
  通常の Linux ディストリビューションを用いる場合、多くのプログラムをインストールすることになりますが、たいていのプログラムは使わないものです。
  それらのプログラムはディスク容量や CPU リソースを無駄に消費することになります。
  CLFS のビルドを 100MB 以内に収めることも可能です。
  これは世に存在するディストリビューションに比べて相当に小さなシステムであるはずです。
  その容量でもまだ大きいと思いますか？
  我々の中には非常に小さな組み込み用の CLFS システム作りにチャレンジしている者もいます。
  実際に Apache ウェブサーバーの起動に特化したシステムを作り出していて、そのディスク容量はほぼ 8MB 程度です。
  そこからもっとスリム化を図れば 5MB 以下になるかもしれません。
  普通のディストリビューションでこれを試してみてください!
  これは Linux 作りを行うことで得られる利点のほんの一つにすぎません。
  </para>
@z

@x
  <para>We could compare Linux distributions to a hamburger purchased at
  a fast-food restaurant&mdash;you have no idea what might be in what you
  are eating. CLFS, on the other hand, does not give you a hamburger.
  Rather, CLFS provides the recipe to make the exact hamburger desired.
  This allows users to review the recipe, omit unwanted ingredients, and
  add your own ingredients to enhance the flavor of the burger. When you
  are satisfied with the recipe, move on to preparing it. It can be made
  to exact specifications&mdash;broil it, bake it, deep-fry it, or
  barbecue it.</para>
@y
  <para>
  Linux ディストリビューションは言ってみればファーストフードレストランで食べるハンバーガーにたとえることができます。
  客にとっては食べているハンバーガーの中に何が入っているのか分からないものです。
  では CLFS はというとハンバーガーを提供するのではありません。
  CLFS が提供するのは求められているハンバーガーを作るためのレシピです。
  レシピを明らかにするわけですから、不要な食材は取り除いて独自のものを加えることができます。
  ハンバーガーの風味を思いのまま増すことができるでしょう。
  レシピに満足できてこそ初めて作業に入ることができます。
  これがまさに手順書です。
  焼くもよし揚げるもよしバーベキューにするのもよし。
</para>
@z

@x
  <para>Another analogy that we can use is that of comparing CLFS with a
  finished house. CLFS provides the skeletal plan of a house, but it is up
  to you to build it. CLFS maintains the freedom to adjust plans throughout
  the process, customizing it to the needs and preferences of the user.</para>
@y
  <para>
  別のたとえで言うなら CLFS は建売住宅にも似ています。
  CLFS は住宅の設計図を提供しますが、それを建てるのはあくまであなたです。
  CLFS は全作業工程において設計図を修正していくのは自由です。
  あなたが必要とする状況や好みに応じていくらでも変えていったらよいのです。
  </para>
@z

@x
  <para>Security is an additional advantage of a custom built Linux system.
  By compiling the entire system from source code, you are empowered to
  audit everything and apply all the security patches desired. It is no
  longer necessary to wait for somebody else to compile binary packages
  that fix a security hole. Unless you examine the patch and implement it
  yourself, you have no guarantee that the new binary package was built
  correctly and adequately fixes the problem.</para>
@y
  <para>
  カスタマイズした Linux システムを構築するもう一つの利点としてセキュリティがあります。
  ソースコードからコンパイルしてシステムを構築するということは、あらゆることを制御する権限を有することになり、セキュリティパッチは望みどおりに適用できます。
  他の人がセキュリティホールを修正しバイナリパッケージを提供するのを待つ必要がなくなるということです。
  他の人がパッチとバイナリパッケージを提供してくれたとしても、それが本当に正しく構築され、問題を解決してくれているかどうかは、調べてみなければ分からないわけですから。
  </para>
@z

@x
  <para>The goal of Cross Linux From Scratch is to build a complete and
  usable foundation-level system. Readers who do not wish to build their
  own Linux system from scratch may not benefit from the information in this
  book. If you only want to know what happens while the computer boots,
  we recommend the <quote>From Power Up To Bash Prompt</quote> HOWTO
  located at <ulink url="http://axiom.anu.edu.au/~okeefe/p2b/"/> or on
  The Linux Documentation Project's (TLDP) website at <ulink
  url="http://www.tldp.org/HOWTO/From-PowerUp-To-Bash-Prompt-HOWTO.html"/>.
  The HOWTO builds a system which is similar to that of this book, but it
  focuses strictly on creating a system capable of booting to a BASH prompt.
  Consider your objective. If you wish to build a Linux system and learn
  along the way, this book is your best choice.</para>
@y
  <para>
  Cross Linux From Scratch の最終目標は、実用的で完全で基盤となるシステムを構築することです。
  Linux システムを一から作り出すつもりのない方は、本書から得られるものはないかもしれません。
  コンピューター起動時に何が起きるかということだけを知りたいなら <quote>From Power Up To Bash
  Prompt</quote> というハウツーが <ulink url="http://axiom.anu.edu.au/~okeefe/p2b/"/> か、Linux ドキュメンテーションプロジェクト (Linux Documentation Project; LDP) の <ulink
  url="http://www.tldp.org/HOWTO/From-PowerUp-To-Bash-Prompt-HOWTO.html"/> にあります。
  このハウツーが構築するシステムは本書が作り出すシステムと似ています。
  しかしこのハウツーは、システムが起動でき BASH プロンプトが利用できるところまでを目指しているだけです。
  目的とするところにもよりますが、Linux システムをビルドしてこれを学んでいこうとするなら、本書こそ読むべきものと思います。
  </para>
@z

@x
  <para>There are too many good reasons to build your own CLFS system to
  list them all here. This section is only the tip of the iceberg. As
  you continue in your CLFS experience, you will find the power that
  information and knowledge truly bring.</para>
@y
  <para>
  CLFS を構築する理由はさまざまですからすべてを列記することはできません。
  ここで示した内容はほんの氷山の一角にすぎません。
  CLFS 構築作業の経験を積むことによって、情報や知識を通じてもたらされる意義が十二分に理解できるはずです。
  </para>
@z