%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Configuring the Linux Console</title>
@y
  <title>Linux コンソールの設定</title>
@z

@x
  <secondary>configuring</secondary></indexterm>
@y
  <secondary>設定</secondary></indexterm>
@z

@x
  <para>This section discusses how to configure the <command>i18n</command>
  bootscript that sets up the keyboard map and the console font. If non-ASCII
  characters (e.g., the British pound sign and Euro character) will not be
  used and the keyboard is a U.S. one, skip this section. Without the
  configuration file, the <command>i18n</command> bootscript will do
  nothing.</para>
@y
  <para>
  この節ではブートスクリプト <command>i18n</command> の設定方法について説明します。
  このスクリプトはキーボードマップ、コンソールフォントを設定します。
  非アスキー文字 (例えばポンド記号、ユーロ記号など) を使わず、キーボードが US 配列であるなら、本節は読み飛ばしてください。
  設定ファイルが存在しない場合は、このスクリプトは何も行いません。
  </para>
@z

@x
  <para>The <command>i18n</command> script reads the
  <filename>/etc/sysconfig/i18n</filename> file for configuration
  information. Decide which keymap and screen font will be used. Various
  language-specific HOWTO's can also help with this (see <ulink
  url="http://www.tldp.org/HOWTO/HOWTO-INDEX/other-lang.html"/>. A pre-made
  <filename>/etc/sysconfig/i18n</filename> file with known settings for
  several countries was installed with the CLFS-Bootscripts package, so the
  relevant section can be uncommented if the country is supported. If still
  in doubt, look in the <filename class="directory">/usr/share/consolefonts</filename>
  for valid screen fonts and <filename class="directory">/usr/share/keymaps</filename>
  for valid keymaps.</para>
@y
  <para>
  <command>i18n</command> スクリプトは、設定情報を <filename>/etc/sysconfig/i18n</filename> ファイルから読み込みます。
  まずは利用するキーボードマップとスクリーンフォントを定めます。
  さまざまな言語に応じた設定方法については <ulink url="http://www.tldp.org/HOWTO/HOWTO-INDEX/other-lang.html"/> を参照してください。
  あらかじめ設定済みの <filename>/etc/sysconfig/i18n</filename> ファイルが CLFS Bootscripts パッケージによりインストールされます。
  このファイルにはよく用いられる国の設定が含まれています。
  そこで該当する国の情報があればコメントアウトするだけで済みます。
  よく分からない場合は、スクリーンフォントについては <filename
  class="directory">/usr/share/consolefonts</filename>、キーマップについては <filename
  class="directory">/usr/share/keymaps</filename> を参照してください。
  </para>
@z

@x
  <para>The default <filename>/etc/sysconfig/i18n</filename> is set up for UTF-8
  using the us keymap. You will need to edit the file to your specific needs.
  The <filename>/etc/sysconfig/i18n</filename> file has additional information
  in it to help you to assist in configuring.</para>
@y
  <para>
  デフォルトの <filename>/etc/sysconfig/i18n</filename> は us キーマップを用いた UTF-8 向けに設定されています。
  必要に応じてこのファイルを書き換えてください。
  <filename>/etc/sysconfig/i18n</filename> ファイル内にはその他の情報も記述されていますので設定時に役立ててください。
  </para>
@z