%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating custom symlinks to devices</title>
@y
  <title>デバイス向けのシンボリックリンク生成</title>
@z

@x
    <title>CD-ROM symlinks</title>
@y
    <title>CD-ROM へのシンボリックリンク</title>
@z

@x
    <para>Some software that you may want to install later (e.g., various
    media players) expect the /dev/cdrom and /dev/dvd symlinks to exist.
    Also, it may be convenient to put references to those symlinks into
    <filename>/etc/fstab</filename>. For each of your CD-ROM devices,
    find the corresponding directory under
    <filename class="directory">/sys</filename> (e.g., this can be
    <filename class="directory">/sys/block/hdd</filename>) and
    run a command similar to the following:</para>
@y
    <para>
    後にインストールしていくソフトウェア (例えばメディアプレーヤーなど) では /dev/cdrom や /dev/dvd といったシンボリックリンクを必要とするものがあります。
    こういったシンボリックリンクは <filename>/etc/fstab</filename> ファイルに設定しておくのが便利です。
    例えば CD-ROM デバイスについては <filename class="directory">/sys</filename> ディレクトリ内 (例えば <filename
    class="directory">/sys/block/hdd</filename>) を確認します。
    そして以下のようなコマンドを実行します。
    </para>
@z

@x
    <para>Look at the lines containing the output of various *_id programs.</para>
@y
    <para>
    出力結果には *_id というプログラム名を示した行がたくさん表示されます。
    </para>
@z

@x
    <para>There are two approaches to creating symlinks. The first one is to
    use the model name and the serial number, the second one is based on the
    location of the device on the bus. If you are going to use the first
    approach, create a file similar to the following:</para>
@y
    <para>
    さてシンボリックリンクの生成方法には二通りあります。
    一つはモデル名とシリアル番号を用いるもの。
    もう一つはバス上のデバイス位置に基づくものです。
    一つめの方法を用いるなら以下のようなファイルを生成します。
    </para>
@z

@x
      <para>Although the examples in this book work properly, be aware
      that Eudev does not recognize the backslash for line continuation.
      If modifying Eudev rules with an editor, be sure to leave each rule
      on one physical line.</para>
@y
      <para>
      本書に示す設定例は適切なものですが、ただし Eudev は行の継続を表わすバックスラッシュを認識しないので注意してください。
      Eudev ルールをテキストエディターにより編集する際には、設定行を必ず一行で記述するようにしてください。
      </para>
@z

@x
    <para>This way, the symlinks will stay correct even if you move the drives
    to different positions on the IDE bus, but the
    <filename>/dev/cdrom</filename> symlink won't be created if you replace
    the old SAMSUNG CD-ROM with a new drive.</para>
@y
    <para>
    上のようにすることで、たとえIDEバス上の別の位置にドライブを付け替えたとしてもシンボリックリンクは正しく動作します。
    ただし古い SAMSUNG の CD-ROM を用いる場合はシンボリックリンクを生成することはできません。
    </para>
@z

@x
    <para>The SUBSYSTEM==&quot;block&quot; key is needed in order to avoid
    matching SCSI generic devices. Without it, in the case with SCSI
    CD-ROMs, the symlinks will sometimes point to the correct
    <filename>/dev/srX</filename> devices, and sometimes to
    <filename>/dev/sgX</filename>, which is wrong.</para>
@y
    <para>
    SUBSYSTEM==&quot;block&quot; というキー項目は SCSI の汎用的なデバイスとは区別されるようにするために必要です。
    この記述がなかった場合 SCSI CD-ROM はたまたま <filename>/dev/srX</filename> というシンボリックリンクとなることもありますが、時には <filename>/dev/sgX</filename> となり誤ったものとなります。
    </para>
@z

@x
    <para>The second approach yields:</para>
@y
    <para>
    二つめの方法は以下のようにします。
    </para>
@z

@x
    <para>This way, the symlinks will stay correct even if you replace drives
    with different models, but place them to the old positions on the IDE
    bus. The ENV{ID_TYPE}==&quot;cd&quot; key makes sure that the symlink
    disappears if you put something other than a CD-ROM in that position on
    the bus.</para>
@y
    <para>
    こうすることでシンボリックリンクはうまく作動します。
    たとえ IDE バス上に別のモデルを接続しても作動しますが、ただし同じ位置でなければなりません。
    ENV{ID_TYPE}==&quot;cd&quot; というキー項目は、そのバス上に CD-ROM 以外のデバイスを設置した場合には取り除いてください。
    </para>
@z

@x
    <para>Of course, it is possible to mix the two approaches.</para>
@y
    <para>
    以上の二通りの方法を混在させても構いません。
    </para>
@z

@x
    <title>Dealing with duplicate devices</title>
@y
    <title>重複するデバイスの取り扱い方</title>
@z

@x
    <para>As explained in <xref linkend="ch-config-eudev"/>, the order in
    which devices with the same function appear in
    <filename class="directory">/dev</filename> is essentially random.
    E.g., if you have a USB web camera and a TV tuner, sometimes
    <filename>/dev/video0</filename> refers to the camera and
    <filename>/dev/video1</filename> refers to the tuner, and sometimes
    after a reboot the order changes to the opposite one.
    For all classes of hardware except sound cards and network cards, this is
    fixable by creating udev rules for custom persistent symlinks.
    The case of network cards is covered separately in
    <xref linkend="chapter-network"/>, and sound card configuration can
    be found in <ulink url="&cblfs-root;">CBLFS</ulink>.</para>
@y
    <para>
    <xref linkend="ch-config-eudev"/> で説明したように、<filename
    class="directory">/dev</filename> 内に同一機能を有するデバイスがあったとすると、その検出順は本質的にランダムです。
    例えば USB 接続のウェブカメラと TV チューナーがあったとして、<filename>/dev/video0</filename> がウェブカメラを、また <filename>/dev/video1</filename> がチューナーをそれぞれ参照していたとしても、システム起動後はその順が逆になることがあります。
    サウンドカードやネットワークカードを除いた他のハードウェアであれば、Udev ルールを適切に記述することで、固定的なシンボリックリンクを作り出すことができます。
    ネットワークカードについては、別途 <xref linkend="chapter-network"/> にて説明しています。
    またサウンドカードの設定方法は <ulink
    url="&cblfs-root;">CBLFS</ulink> にて説明しています。
    </para>
@z

@x
    <para>For each of your devices that is likely to have this problem
    (even if the problem doesn't exist in your current Linux distribution),
    find the corresponding directory under
    <filename class="directory">/sys/class</filename> or
    <filename class="directory">/sys/block</filename>.
    For video devices, this may be
    <filename
    class="directory">/sys/class/video4linux/video<replaceable>X</replaceable></filename>.
    Figure out the attributes that identify the device uniquely (usually,
    vendor and product IDs and/or serial numbers work):</para>
@y
    <para>
    利用しているデバイスに上の問題の可能性がある場合 (お使いの Linux ディストリビューションではそのような問題がなかったとしても) <filename
    class="directory">/sys/class</filename> ディレクトリや <filename class="directory">/sys/block</filename> ディレクトリ配下にある対応ディレクトリを探してください。
    ビデオデバイスであれば <filename class="directory">/sys/class/video4linux/video<replaceable>X</replaceable></filename> といったディレクトリです。
    そしてそのデバイスを一意に特定する識別情報を確認してください。
    (通常はベンダー名、プロダクトID、シリアル番号などです。)
    </para>
@z

@x
    <para>Then write rules that create the symlinks, e.g.:</para>
@y
    <para>
    シンボリックリンクを生成するルールを作ります。
    </para>
@z

@x
    <para>The result is that <filename>/dev/video0</filename> and
    <filename>/dev/video1</filename> devices still refer randomly to the tuner
    and the web camera (and thus should never be used directly), but there are
    symlinks <filename>/dev/tvtuner</filename> and
    <filename>/dev/webcam</filename> that always point to the correct
    device.</para>
@y
    <para>
    こうしたとしても <filename>/dev/video0</filename> と <filename>/dev/video1</filename> はチューナーとウェブカメラのいずれかをランダムに指し示すことに変わりありません。
    (したがって直接このデバイス名を使ってはなりません。)
    しかしシンボリックリンク <filename>/dev/tvtuner</filename> と <filename>/dev/webcam</filename> は常に正しいデバイスを指し示すようになります。
    </para>
@z

@x
    <para>More information on writing Eudev rules can be found in
    <filename>/usr/share/doc/udev/writing_udev_rules/index.html</filename>.</para>
@y
    <para>
    Eudev ルールの詳細は <filename>/usr/share/doc/udev/writing_udev_rules/index.html</filename> に示されていますので参照してください。
    </para>
@z