%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The GCC package contains the GNU compiler collection, which includes
    the C and C++ compilers.</para>
@y
    <para>
    GCC パッケージは C コンパイラーや C++ コンパイラーなどの GNU コンパイラーコレクションを提供します。
    </para>
@z

@x
    <title>Installation of GCC</title>
@y
    <title>&InstallationOf1;GCC &InstallationOf2;</title>
@z

@x
    <para os="p1">The following patch contains a number of updates to the 
    &gcc-version; branch by the GCC developers:</para>
@y
    <para os="p1">
    以下のパッチは、GCC 開発者による &gcc-version; ブランチの数々の更新を提供するものです。
    </para>
@z

@x
    <para os="fix1">Apply a <command>sed</command> substitution that will
    suppress the execution of the <command>fixincludes</command> script:</para>
@y
    <para os="fix1">
    以下の <command>sed</command> コマンド置換によって、<command>fixincludes</command> スクリプトを実行しないようにします。
    </para>
@z

@x
    <para os="f">The GCC documentation recommends building GCC outside of the source
    directory in a dedicated build directory:</para>
@y
    <para os="f">
    GCC のドキュメントによると GCC のビルドにあたっては、ソースディレクトリ以外の専用のビルドディレクトリを作成することが推奨されています。
    </para>
@z

@x
    <para os="h">Prepare GCC for compilation:</para>
@y
    <para os="h">&PreparePackage1;GCC &PreparePackage2;</para>
@z

@x
      <title>The meaning of the new configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x SED=sed
          <para>This prevents a hard-coded path to
          <filename>/tools/bin/sed</filename> in the <command>fixincl</command>
          program.</para>
@y
          <para>
          <command>fixincl</command> プログラムにおいて <filename>/tools/bin/sed</filename> へのパスがハードコーディングされないようにします。
          </para>
@z

@x --disable-bootstrap
          <para>For a native build, GCC defaults to performing a 3-stage
          "bootstrap" of the compiler. This means that GCC is compiled a total
          of 3 times - it is compiled once, the first stage compiler is used
          to build itself again, and the second stage compiler builds itself
          once more. The second and third passes are then compared, verifying
          that GCC is able to reproduce itself successfully. However, there is
          no need for this with the CLFS build process so we disable it here.</para>
@y
          <para>
          ネイティブビルドにおいて GCC はデフォルトでは3ステージめの "ブートストラップ" コンパイラーを用います。
          これにより GCC は計3回コンパイルされるわけです。
          1回めのコンパイルの後、このコンパイラーを用いて2回めが処理され、2回めのコンパイラーを使って再度コンパイルします。
          そして2回めと3回めのコンパイラーが比較検証されて初めて、GCC が自分自身を生み出すことができることになります。
          しかし CLFS のビルド手順においてこのようなことは不要です。
          ここでそれを無効とします。
          </para>
@z

@x
    <para os="j">Compile the package:</para>
@y
    <para os="j">&CompileThePackage;</para>
@z

@x
      <para>Due to GCC's critical role in a properly functioning system,
      the CLFS developers strongly recommend running the testsuite.</para>
@y
      <para>
      GCC はシステムを適切に動作させるための重要な役割を持っています。
      したがって CLFS 開発者としてはテストスイートの実行を強く勧めます。
      </para>
@z

@x
   <para os="s1">Increase the stack size prior to running the tests:</para>
@y
   <para os="s1">
   テスト実施にあたり、スタックサイズを増やします。
   </para>
@z

@x
    <para os="m">Test the results, but do not stop at errors:</para>
@y
    <para os="m">
    ビルド結果をテストします。
    エラーが発生しても停止しないようにします。
    </para>
@z

@x
    <para os="o">The <parameter>-k</parameter> flag is used to make the test suite
    run through to completion and not stop at the first failure. The GCC test
    suite is very comprehensive and is almost guaranteed to generate a few
    failures. To receive a summary of the test suite results, run:</para>
@y
    <para os="o">
    <parameter>-k</parameter> フラグをつけるのは最後までテストスイートを実行させるためです。
    失敗があってもすぐ止まることがないようにします。
    GCC のテストスイートは広範囲に行われるもので、たいていは正常実行されますが失敗するものも多少はあります。
    テスト結果を確認するために以下を実行します。
    </para>
@z

@x
    <para os="q">For only the summaries, pipe the output through
    <userinput>grep -A7 Summ</userinput>.</para>
@y
    <para os="q">
    テスト結果の概略のみ確認したい場合は、出力結果をパイプ出力して <userinput>grep -A7 Summ</userinput> を実行してください。
    </para>
@z

@x
    <para os="r">A few unexpected failures cannot always be avoided. The
    GCC developers are usually aware of these issues, but have not
    resolved them yet.</para>
@y
    <para os="r">
    テストに失敗することがありますが、これを回避することはできません。
    GCC の開発者はこの問題を認識していますが、まだ解決していない状況です。
    </para>
@z

@x
    <para os="s">Install the package:</para>
@y
    <para os="s">&InstallThePackage;</para>
@z

@x
    <para os="w">Create a link to satisfy FHS requirements:</para>
@y
    <para os="w">
    FHS に準拠するためリンクを作成します。
    </para>
@z

@x
    <para os="y">Many packages use the name <command>cc</command> to call the C
    compiler. To satisfy those packages, create a symlink:</para>
@y
    <para os="y">
    各種パッケージは C コンパイラーとして <command>cc</command> を呼び出しているものが数多くあります。
    これに対応するため、以下のシンボリックリンクを作成します。
    </para>
@z

@x
    <para os="aa">Finally, move a misplaced file:</para>
@y
    <para os="aa">
    最後に誤ったディレクトリにあるファイルを移動します。
    </para>
@z

@x
    <title>Contents of GCC</title>
@y
    <title>&ContentsOf1;GCC &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed libraries</segtitle>
      <segtitle>Installed directories</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledLibrary;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>c++, cc (link to gcc), cpp, g++, gcc, gcov, gcov-tool</seg>
        <seg>libasan.[a,so], libatomic.[a,so], libcc1.so, libcilkrts.[a,so],
        libgcc.a, libgcc_eh.a, libgcc_s.so, libgcov.a, libgomp.[a,so],
        libiberty.a, libitm.[a,so], liblsan.[a,so], liblto_plugin.so,
        libquadmath.[a,so], libssp.[a,so], libssp_nonshared.a,
        libstdc++.[a,so], libsupc++.a, libtsan.[a,so], libubsan.[a,so],
        libvtv.[a,so]</seg>
        <seg>/usr/include/[c++,libiberty], /usr/lib/gcc,
        /usr/share/gcc-&gcc-version;</seg>
@y
        <seg>c++, cc (&LinkTo1;gcc &LinkTo2;), cpp, g++, gcc, gcov, gcov-tool</seg>
        <seg>libasan.[a,so], libatomic.[a,so], libcc1.so, libcilkrts.[a,so],
        libgcc.a, libgcc_eh.a, libgcc_s.so, libgcov.a, libgomp.[a,so],
        libiberty.a, libitm.[a,so], liblsan.[a,so], liblto_plugin.so,
        libquadmath.[a,so], libssp.[a,so], libssp_nonshared.a,
        libstdc++.[a,so], libsupc++.a, libtsan.[a,so], libubsan.[a,so],
        libvtv.[a,so]</seg>
        <seg>/usr/include/[c++,libiberty], /usr/lib/gcc,
        /usr/share/gcc-&gcc-version;</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x cc
          <para>The C compiler</para>
@y
          <para>C コンパイラー</para>
@z

@x cpp
          <para>The C preprocessor; it is used by the compiler to expand the
          #include, #define, and similar statements in the source files</para>
@y
          <para>
          C プリプロセッサー。
          コンパイラーがこれを利用して、ソース内に記述された #include、#define や同じようなステートメントを展開します。
          </para>
@z

@x c++
          <para>The C++ compiler</para>
@y
          <para>C++ コンパイラー</para>
@z

@x g++
          <para>The C++ compiler</para>
@y
          <para>C++ コンパイラー</para>
@z

@x gcc
          <para>The C compiler</para>
@y
          <para>C コンパイラー</para>
@z

@x gcov
          <para>A coverage testing tool; it is used to analyze programs to
          determine where optimizations will have the most effect</para>
@y
          <para>
          カバレッジテストツール。
          プログラムを解析して、最適化が最も効果的となるのはどこかを特定します。
          </para>
@z

@x gcov-tool
          <para>An offline tool to handle gcda counts</para>
@y
          <para>
          gcda カウントを取り扱うオフラインツール。
          </para>
@z

@x libasan
          <para>The Address Sanitizer runtime library</para>
@y
          <para>
          アドレスサニタイザー (Address Sanitizer) のランタイムライブラリ。
          </para>
@z

@x libatomic
          <para>A GCC support runtime library for atomic operations not
          supported by hardware</para>
@y
          <para>
          ハードウェアではサポートされないアトミック操作 (atomic operations) のために GCC がサポートするランタイムライブラリ。
          </para>
@z

@x libcc1
          <para>Translates API into RPC calls</para>
@y
          <para>
          API を RPC コールに変換します。
          </para>
@z

@x libcilkrts
          <para>Intel&reg; Cilk&trade; Plus runtime library</para>
@y
          <para>
          Intel&reg; Cilk&trade; Plus ランタイムライブラリ。
          </para>
@z

@x libgcc
          <para>Contains run-time support for <command>gcc</command></para>
@y
          <para>
          <command>gcc</command> のランタイムサポートを提供します。
          </para>
@z

@x libgcov
          <para>Library that is linked into a program when
          <command>gcc</command> is instructed to enable profiling</para>
@y
          <para>
          <command>gcc</command> のプロファイリングを有効にした場合にこのライブラリがリンクされます。
          </para>
@z

@x libgomp
          <para>GNU implementation of the OpenMP API for multi-platform
          shared-memory parallel programming in C/C++ and Fortran</para>
@y
          <para>
          C/C++ や Fortran においてマルチプラットフォームでの共有メモリ並行プログラミング
          (multi-platform shared-memory parallel programming)
          を行うための GNU による OpenMP API インプリメンテーションです。
          </para>
@z

@x libiberty
          <para>Contains routines used by various GNU programs, including
          <command>getopt</command>, <command>obstack</command>,
          <command>strerror</command>, <command>strtol</command>, and
          <command>strtoul</command></para>
@y
          <para>
          以下に示すような数多くの GNU プログラムが利用する処理ルーチンを提供します。
          <command>getopt</command>、
          <command>obstack</command>、
          <command>strerror</command>、
          <command>strtol</command>、
          <command>strtoul</command>
          </para>
@z

@x libitm
          <para>The GNU Transactional Memory Library, which provides
          transaction support for accesses to a process's memory</para>
@y
          <para>
          GNU トランザクショナルメモリ (GNU Transactional Memory) ライブラリ。
          これはプロセスのメモリ上へのトランザクションを考慮したサポートを行います。
          </para>
@z

@x liblsan
          <para>The Leak Sanitizer runtime library</para>
@y
          <para>
          Leak Sanitizer ランタイムライブラリ。
          </para>
@z

@x liblto_plugin
          <para>Runtime library for GCC's link-time optimization plugin</para>
@y
          <para>
          GCC のリンク時における最適化プラグインのためのランタイムライブラリ。
          </para>
@z

@x libquadmath
          <para>The GCC Quad-Precision Math Libarary API</para>
@y
          <para>
          GCC の4倍精度数値演算 (Quad Precision Math) ライブラリ API
          </para>
@z

@x libssp
          <para>Contains routines supporting GCC's stack-smashing protection
          functionality</para>
@y
          <para>
          GCC のスタック破壊を防止する (stack-smashing protection) 機能をサポートするルーチンを提供します。
          </para>
@z

@x libstdc++
          <para>The standard C++ library</para>
@y
          <para>標準 C++ ライブラリ</para>
@z

@x libsupc++
          <para>Provides supporting routines for the C++ programming
          language</para>
@y
          <para>
          C++ プログラミング言語のためのサポートルーチンを提供します。
          </para>
@z

@x libtsan
          <para>The Thread Sanitizer runtime library</para>
@y
          <para>
          スレッドサニタイザー (Thread Sanitizer) のランタイムライブラリ。
          </para>
@z

@x libubsan
          <para>The Undefined Behavior Sanitizer runtime library</para>
@y
          <para>
          Undefined Behavior Sanitizer ランタイムライブラリ。
          </para>
@z

@x libvtv
          <para>The Virtual Table Verification runtime library</para>
@y
          <para>
          Virtual Table Verification ランタイムライブラリ。
          </para>
@z