%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Mounting the New Partition</title>
@y
  <title>新しいパーティションのマウント</title>
@z

@x
  <para>Now that a file system has been created, the partition needs to
  be made accessible. In order to do this, the partition needs to be
  mounted at a chosen mount point.</para>
@y
  <para>
  ファイルシステムが生成できたら、パーティションをアクセスできるようにします。
  これを行うためにはマウントポイントを定める必要があります。
  </para>
@z

@x
  <para>As the <systemitem class="username">root</systemitem> user, ensure the
  <envar>CLFS</envar> variable is set, if you haven't already:</para>
@y
  <para>
  <envar>CLFS</envar> 変数がセットされていることを確認してください。
  セットされていない場合は <systemitem class="username">root</systemitem> ユーザーになって以下を実行します。
  </para>
@z

@x
  <para>Next, create the mount point and mount the CLFS file system by
  running the following commands as
  <systemitem class="username">root</systemitem>:</para>
@y
  <para>
  次にマウントポイントを生成し CLFS ファイルシステムをマウントします。
  <systemitem class="username">root</systemitem> ユーザーになって以下を実行します。
  </para>
@z

@x
  <para>Replace <replaceable>[xxx]</replaceable> with the designation of
  the CLFS partition.</para>
@y
  <para>
  <replaceable>[xxx]</replaceable> の部分は CLFS パーティション名に合わせて置き換えてください。
  </para>
@z

@x
  <para>If using multiple partitions for CLFS (e.g., one for <filename
  class="directory">/</filename> and another for <filename
  class="directory">/usr</filename>), mount them as
  <systemitem class="username">root</systemitem> using:</para>
@y
  <para>
  CLFS において複数のパーティションを利用する場合 (例えば <filename
  class="directory">/</filename> と <filename
  class="directory">/usr</filename> など) 、<systemitem
  class="username">root</systemitem> ユーザーになって以下のようにマウントします。
  </para>
@z

@x
  <para>Replace <replaceable>[xxx]</replaceable> and
  <replaceable>[yyy]</replaceable> with the appropriate partition
  names.</para>
@y
  <para>
  <replaceable>[xxx]</replaceable> と <replaceable>[yyy]</replaceable> の部分は、それぞれ適切なパーティション名に置き換えてください。
  </para>
@z

@x
  <para>Ensure that this new partition is not mounted with permissions
  that are too restrictive (such as the <option>nosuid</option>,
  <option>nodev</option>, or <option>noatime</option> options).
  Run <command>mount | grep ${CLFS}</command> to see
  what options are set for the mounted CLFS partition. If
  <option>nosuid</option>, <option>nodev</option>, and/or
  <option>noatime</option> are set, the partition will need to be
  remounted.</para>
@y
  <para>
  この新しいパーティションは特別な制限オプション (<option>nosuid</option>,
  <option>nodev</option>, <option>noatime</option> など) は設定せずにマウントします。 
  <command>mount | grep ${CLFS}</command> というコマンドを実行すれば、CLFS パーティションがどのようなオプション設定によりマウントされているかが分かります。
  もし <option>nosuid</option>, <option>nodev</option>,
  <option>noatime</option> オプションが設定されていたら、マウントし直してください。 
  </para>
@z

@x
  <para>Now that there is an established place to work, it is time to
  download the packages.</para>
@y
  <para>
  こうして動作環境が整いました。次はパッケージのダウンロードです。
  </para>
@z