%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Setting Up the Environment</title>
@y
  <title>環境設定</title>
@z

@x
  <para>The new instance of the shell that will start when the system is booted is a <emphasis>login</emphasis>
  shell, which will read the <filename>.bash_profile</filename> file. Create
  <filename>.bash_profile</filename> now:</para>
@y
  <para>
  システム起動時に新しく起動するシェルは<emphasis>ログイン</emphasis> シェルです。
  このシェルは <filename>.bash_profile</filename> ファイルを読み込みます。
  そこで <filename>.bash_profile</filename> ファイルを生成します。
  </para>
@z

@x
  <para>The <envar>LC_ALL</envar> variable controls the localization of
  certain programs, making their messages follow the conventions of a
  specified country.
  Setting <envar>LC_ALL</envar> to <quote>POSIX</quote> or <quote>C</quote>
  (the two are equivalent) ensures that everything will work as expected
  on your temporary system.</para>
@y
  <para>
  <envar>LC_ALL</envar> 変数は特定のプログラムが扱う国情報を制御します。
  そのプログラムが出力するメッセージを、指定された国情報に基づいて構成します。
  <envar>LC_ALL</envar> 変数は<quote>POSIX</quote>か<quote>C</quote>にセットしてください。
  (両者は同じです。)
  そのようにセットしておけば一時システム内での作業が問題なく進められます。
  </para>
@z

@x
  <para>By putting <filename class="directory">/tools/bin</filename> and
  <filename class="directory">/tools/sbin</filename> at
  the end of the standard <envar>PATH</envar>, all the programs installed in
  <xref linkend="chapter-temp-system"/> are only picked up by the shell
  if they have not yet been built on the target system. This configuration
  forces use of the final system binaries as they are built over the
  temp-system, minimising the chance of final system programs being built
  against the temp-system.</para>
@y
  <para>
  <filename class="directory">/tools/bin</filename> ディレクトリと <filename
  class="directory">/tools/sbin</filename> ディレクトリを PATH 変数の終わりに設定します。
  <xref linkend="chapter-temp-system"/>にてインストールしたプログラムは、ターゲットシステム内にビルドされていない場合に限って実行されます。
  このように設定するのは、一時システムを通してビルドした最終システムの実行モジュールを優先して利用するのが目的です。
  そして最終システムのプログラムが一時システムに依存してビルドされることを極力避けるものでもあります。
  </para>
@z