%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Mounting Virtual Kernel File Systems</title>
@y
  <title>仮想カーネルファイルシステムのマウント</title>
@z

@x
      <para>The commands in the remainder of the book should be run as
      the <systemitem class="username">root</systemitem> user. Check
      that ${CLFS} is set in the
      <systemitem class="username">root</systemitem> user&rsquo;s environment
       before proceeding.</para>
@y
      <para>
      本書のこれ以降のコマンドはすべて <systemitem class="username">root</systemitem> ユーザーにより実行してください。
      また作業を進めるにあたり <systemitem class="username">root</systemitem> ユーザーの環境変数 ${CLFS} が設定されていることを確認してください。
      </para>
@z

@x
  <para>Various file systems exported by the kernel are used to communicate
  to and from the kernel itself. These file systems are virtual in that no
  disk space is used for them. The content of the file systems resides in
  memory.</para>
@y
  <para>
  カーネルが取り扱うさまざまなファイルシステムは、カーネルとの間でやり取りが行われます。
  これらのファイルシステムは仮想的なものであり、ディスクを消費するものではありません。
  ファイルシステムの内容はメモリ上に保持されます。
  </para>
@z

@x
  <para>Begin by creating directories onto which the file systems will
  be mounted:</para>
@y
  <para>
  ファイルシステムをマウントするディレクトリを以下のようにして生成します。
  </para>
@z

@x
  <para>Two device nodes, <filename class="devicefile">/dev/console</filename>
  and <filename class="devicefile">/dev/null</filename>, are required to be
  present on the file system. These are needed by the kernel even before
  starting Udev early in the boot process, so we create them here:</para>
@y
  <para>
  <filename class="devicefile">/dev/console</filename> と <filename
  class="devicefile">/dev/null</filename> という2つのデバイスノードはハードディスク上に生成されていなければなりません。
  これらはカーネルに対して必要となるもので、システム起動時の Udev 起動よりもさらに前段階で必要となります。
  そこで以下のようにしてこれらを生成します。
  </para>
@z

@x
  <para>Once the system is complete and booting, the rest of our device
  nodes will be created by the kernel's
  <systemitem class="filesystem">devtmpfs</systemitem> file system. For now
  though, we will just use the <quote>bind</quote> option in the mount command
  to make our host system's <filename class="directory">/dev</filename> structure appear in the new CLFS file system:</para>
@y
  <para>
  システムが完成し起動の段階になると、カーネルの <systemitem
  class="filesystem">devtmpfs</systemitem> によって多くのデバイスノードが生成されます。
  しかしここでは mount コマンドの <quote>bind</quote> オプションを利用して、ホストシステムの <filename
  class="directory">/dev</filename> 構造を CLFS ファイルシステムとして見せるようにします。
  </para>
@z

@x
  <para>Now mount the remaining file systems:</para>
@y
  <para>
  これ以外にさらに以下のファイルシステムをマウントします。
  </para>
@z

@x
  <para>On some host systems, <filename class="directory">/dev/shm</filename>
  is a symbolic link to <filename class="directory">/run/shm</filename>.
  If it is, create a directory in <filename class="directory">/run</filename>:</para>
@y
  <para>
  ホストシステムによっては <filename class="directory">/dev/shm</filename> が <filename
  class="directory">/run/shm</filename> へのシンボリックリンクになっているものがあります。
  そのようなシステムでは <filename class="directory">/run</filename> 配下にディレクトリを生成します。
  </para>
@z

@x
  <para>Remember that if for any reason you stop working on the CLFS system
  and start again later, it is important to check that these file systems
  are mounted again before entering the chroot environment.</para>
@y
  <para>
  何かの理由によって CLFS システム作業を中断しその後に再開することになった場合は、chroot 環境に入る前に上のファイルシステムがマウントされていることを確認してください。
  </para>
@z