%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>cross tools</secondary>
@y
    <secondary>&CrossTools;</secondary>
@z

@x
    <title>Installation of Pkg-config-lite</title>
@y
    <title>&InstallationOf1;Pkg-config-lite &InstallationOf2;</title>
@z

@x
    <para os="a">Several packages in the temporary system will use
    <command>pkg-config</command> to find various required and optional
    dependencies. Unfortunately, this could result in those packages
    finding libraries on the host system and trying to link against them,
    which will not work. To avoid this problem, we will install
    a <command>pkg-config</command> binary in
    <filename class="directory">/cross-tools</filename> and configure it so
    that it will look for Pkg-config files only in
    <filename class="directory">/tools</filename>.</para>
@y
    <para os="a">
    一時システムにおけるパッケージの中で <command>pkg-config</command> を利用して必須あるいは任意の依存パッケージを探すものがあります。
    これをそのままにしておくと、そのようなパッケージはホストシステム上のライブラリなどを探し出しリンクしてしまいます。
    これではシステムが動作しなくなります。
    そうならないように <command>pkg-config</command> プログラムは <filename
    class="directory">/cross-tools</filename> ディレクトリにインストールし、configure において Pkg-config ファイルが <filename
    class="directory">/tools</filename> ディレクトリから取得されるようにします。
    </para>
@z

@x
    <para os="b">Prepare Pkg-config-lite for compilation:</para>
@y
    <para os="b">&PreparePackage1;Pkg-config-lite &PreparePackage2;</para>
@z

@x
      <title>The meaning of the new configure option:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --host=${CLFS_TARGET}
          <para>Several packages that we will cross-compile later will try to
          search for <command>${CLFS_TARGET}-pkg-config</command>. Setting
          this option ensures that Pkg-config-lite will create a hard
          link in <filename class="directory">/cross-tools/bin</filename> with
          this name, so that it will be used instead of any similarly-named
          program that might exist on the host.</para>
@y
          <para>
          これ以降にクロスコンパイルするパッケージの中には <command>${CLFS_TARGET}-pkg-config</command> を探し出そうとするものがあります。
          そこでこのオプションを指定し <filename
          class="directory">/cross-tools/bin</filename> ディレクトリ内に Pkg-config-lite のハードリンクをこの名前で生成します。
          こうすることで、ホストシステムに類似するプログラム名があったとしてもそれが用いられないようにします。
          </para>
@z

@x --with-pc-path
          <para>This sets the default PKG_CONFIG_PATH to
          <filename class="directory">/tools/lib/pkgconfig</filename> and
          <filename class="directory">/tools/share/pkgconfig</filename>.</para>
@y
          <para>
          デフォルトの PKG_CONFIG_PATH を <filename
          class="directory">/tools/lib/pkgconfig</filename> と <filename
          class="directory">/tools/share/pkgconfig</filename> に設定します。
          </para>
@z

@x
    <para os="e">Compile the package:</para>
@y
    <para os="e">&CompileThePackage;</para>
@z

@x
    <para os="g">Install the package:</para>
@y
    <para os="g">&InstallThePackage;</para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-pkg-config-lite" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-pkg-config-lite" role=""/>&Details2;
    </para>
@z