%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The systemd package is a system and service manager for Linux
    operating systems.</para>
@y
    <para>
    systemd パッケージは Linux におけるシステムサービスマネージャーです。
    </para>
@z

@x
    <title>Installation of Systemd</title>
@y
    <title>&InstallationOf1;Systemd &InstallationOf2;</title>
@z

@x
    <para os="s1">Prevent the <filename>Makefile</filename> from trying to run
    <command>setcap</command> on <command>systemd-detect-virt</command>,
    which will fail if the kernel or file system does not support extended
    capabilities:</para>
@y
    <para os="s1">
    以下のコマンドを実行します。
    これは <command>systemd-detect-virt</command> において <command>setcap</command> を実行しないように <filename>Makefile</filename> を修正するものです。
    このようにしておかないと、カーネルあるいはファイルシステムが拡張属性に対応していない場合にビルドできなくなるからです。
    </para>
@z

@x
    <para os="s3">The <filename>timesyncd.conf</filename> file contains a
    reference to a non-existent <filename>timesyncd.conf(5)</filename> man
    page. Remove that reference to avoid possible confusion:</para>
@y
    <para os="s3">
    <filename>timesyncd.conf</filename> ファイルには <filename>timesyncd.conf(5)</filename> という存在しない man ページへの参照が含まれています。
    混乱が生じないようにその参照は削除します。
    </para>
@z

@x
    <para os="cc1">Create a file to declare some variables</para>
@y
    <para os="cc1">
    ファイルを一つ生成して変数をいくつか宣言します。
    </para>
@z

@x
    <para os="a">Prepare systemd for compilation:</para>
@y
    <para os="a">&PreparePackage1;systemd &PreparePackage2;</para>
@z

@x
      <title>The meaning of the configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --config-cache
          <para>Use the created <filename>config.cache</filename>.</para>
@y
          <para>
          上で生成した <filename>config.cache</filename> を利用することを指示します。
          </para>
@z

@x --with-root*
          <para>These switches ensure that core programs and
          shared libraries are installed in the subdirectories
          of the root partition.</para>
@y
          <para>
          これらのスイッチは主要なプログラムや共有ライブラリを、ルートパーティション配下のサブディレクトリにインストールすることを指示します。
          </para>
@z

@x --enable-split-usr
          <para>This switch ensures that systemd will work on
          systems where /bin, /lib and /sbin directories are not
          symlinks to their /usr counterparts.</para>
@y
          <para>
          このスイッチは、/bin, /lib, /sbin の各ディレクトリが /usr 配下の同一サブディレクトリ名によるシンボリックリンクでない場合でも systemd が稼動するようにするものです。
          </para>
@z

@x --disable-firstboot
          <para>This switch prevents installation of systemd services 
            responsible for setting up the system for the first time.
            They are not useful for CLFS as everything is done manually.
          </para>
@y
          <para>
          このスイッチは、システム起動初期にシステム設定を行う systemd サービスをインストールしないようにします。
          CLFS ではすべてを手作業で設定していくためです。
          </para>
@z

@x --disable-ldconfig
          <para>This switch prevents installation of a systemd unit that runs
          <command>ldconfig</command> at boot, and increases boot time.
          While it may be not useful for source distributions like CLFS,
          this option may be removed.</para>
@y
          <para>
          このスイッチは、システム起動時に <command>ldconfig</command> を実行する systemd ユニットをインストールしないようにします。
          これがあると起動処理に時間がかかります。
          CLFS のようにソースから作り出すディストリビューションにとっては無用なものですが、必要ならこのスイッチを取り除いてください。
          </para>
@z

@x --disable-lto
          <para>This prevents the build system from using GCC's Link-time
          optimization (LTO), to ensure that systemd's binaries will not try
          to link to <filename class="libraryfile">libgcc_s</filename></para>
@y
          <para>
          このスイッチは GCC の LTO (Link-time optimization) を用いないようにします。
          これにより systemd の実行モジュールは <filename
          class="libraryfile">libgcc_s</filename> をリンクしなくなります。
          </para>
@z

@x --disable-sysusers
            <para>This switch prevents install of systemd services which setup
            the previously created <filename>/etc/group</filename> and
            <filename>/etc/passwd</filename> files.</para>
@y
            <para>
            このスイッチは、システム起動初期に /etc/group ファイルと /etc/passwd ファイルを設定する systemd サービスをインストールしないようにします。
            </para>
@z

@x --with-dbus*
          <para>These switches ensure that D-Bus configuration files get
          installed to the correct locations.</para>
@y
          <para>
          本スイッチは D-Bus の設定ファイル類を適切なディレクトリにインストールすることを指示します。
          </para>
@z

@x --with-default-dnssec=no
          <para>This switch turns off the experimental DNSSEC support.</para>
@y
          <para>
          このスイッチは DNSSEC に関する実験的なサポートを無効にします。
          </para>
@z

@x
    <para os="d">Compile the package:</para>
@y
    <para os="d">&CompileThePackage;</para>
@z

@x
    <para os="f">Prevent a broken test case from running:</para>
@y
    <para os="f">
    不備のあるテストケースを実行しないようにします。
    </para>
@z

@x
    <para os="h">To test the results, issue:</para>
@y
    <para os="h">
    ビルド結果をテストする場合は以下を実行します。
    </para>
@z

@x
    <para os="j">Install the package:</para>
@y
    <para os="j">&InstallThePackage;</para>
@z

@x
    <para os="l">Install documentation files that are not installed by default:</para>
@y
    <para os="l">
    ドキュメントをインストールします。
    デフォルトではインストールされません。
    </para>
@z

@x
    <para os="p">Remove an unnecessary directory:</para>
@y
    <para os="p">
    不要なディレクトリを削除します。
    </para>
@z

@x
    <para os="r">Create symlinks for backwards-compatibility with Sysvinit:</para>
@y
    <para os="r">
    Sysvinit との下位互換のためにシンボリックリンクを生成します。
    </para>
@z

@x
    <title>Configuring Systemd</title>
@y
    <title>&Configuring1;Systemd &Configuring2;</title>
@z

@x
    <secondary>configuring</secondary></indexterm>
@y
    <secondary>設定</secondary></indexterm>
@z

@x
    <para>Create <filename>/etc/machine-id</filename> which is needed
    by Journald:</para>
@y
    <para>
    Journald に必要となる <filename>/etc/machine-id</filename> を生成します。
    </para>
@z

@x
    <para>Create a file to identify the operating system.
    <command>systemd</command> will use this file on boot to put information
    on the screen.</para>
@y
    <para>
    オペレーティングシステムを識別するためのファイルを生成します。
    <command>systemd</command> は起動時にこのファイルを参照し画面出力を行います。
    </para>
@z

@x
    <title>Contents of Systemd</title>
@y
    <title>&ContentsOf1;Systemd &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed libraries</segtitle>
      <segtitle>Installed directories</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledLibrary;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>bootctl, busctl, halt (link to systemctl), hostnamectl,
        init (link to systemd), journalctl, kernel-install, localectl, loginctl,
        machinectl, poweroff (link to systemctl), reboot (link to systemctl),
        runlevel (link to systemctl), shutdown (link to systemctl),
        systemctl, systemd, system-analyze, systemd-ask-password, systemd-cat,
        systemd-cgls, systemd-cgtop, systemd-coredumpctl, systemd-delta,
        systemd-detect-virt, systemd-inhibit, systemd-machine-id-setup,
        systemd-notify, systemd-nspawn, systemd-run, systemd-stdio-bridge
        (link to systemd-bus-proxyd), systemd-tmpfiles,
        systemd-tty-ask-password-agent, telinit (link to systemctl),
        timedatectl, udevadm</seg>
        <seg>libnss_myhostname.so, libsystemd.so, libudev.so</seg>
        <seg>/etc/binfmt.d, /etc/init.d, /etc/kernel, /etc/modules-load.d,
        /etc/sysctl.d, /etc/systemd, /etc/tmpfiles.d, /etc/udev,
        /etc/xdg/systemd, /lib/systemd, /lib/udev, /usr/include/systemd,
        /usr/lib/binfmt.d, /usr/lib/kernel, /usr/lib/modules-load.d,
        /usr/lib/sysctl.d, /usr/lib/systemd,
        /usr/share/doc-systemd-&systemd-version;, /usr/share/systemd,
        /usr/share/zsh, /var/lib/systemd</seg>
@y
        <seg>bootctl, busctl, halt (&LinkTo1;systemctl &LinkTo2;), hostnamectl,
        init (&LinkTo1;systemd &LinkTo2;), journalctl, kernel-install, localectl, loginctl,
        machinectl, poweroff (&LinkTo1;systemctl &LinkTo2;), reboot (&LinkTo1;systemctl &LinkTo2;),
        runlevel (&LinkTo1;systemctl &LinkTo2;), shutdown (&LinkTo1;systemctl &LinkTo2;),
        systemctl, systemd, system-analyze, systemd-ask-password, systemd-cat,
        systemd-cgls, systemd-cgtop, systemd-coredumpctl, systemd-delta,
        systemd-detect-virt, systemd-inhibit, systemd-machine-id-setup,
        systemd-notify, systemd-nspawn, systemd-run, systemd-stdio-bridge
        (&LinkTo1;systemd-bus-proxyd &LinkTo2;), systemd-tmpfiles,
        systemd-tty-ask-password-agent, telinit (&LinkTo1;systemctl &LinkTo2;),
        timedatectl, udevadm</seg>
        <seg>libnss_myhostname.so, libsystemd.so, libudev.so</seg>
        <seg>/etc/binfmt.d, /etc/init.d, /etc/kernel, /etc/modules-load.d,
        /etc/sysctl.d, /etc/systemd, /etc/tmpfiles.d, /etc/udev,
        /etc/xdg/systemd, /lib/systemd, /lib/udev, /usr/include/systemd,
        /usr/lib/binfmt.d, /usr/lib/kernel, /usr/lib/modules-load.d,
        /usr/lib/sysctl.d, /usr/lib/systemd,
        /usr/share/doc-systemd-&systemd-version;, /usr/share/systemd,
        /usr/share/zsh, /var/lib/systemd</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x bootctl
          <para>Controls the firmware and boot manager settings</para>
@y
          <para>
          ファームウェアやブートマネージャーの設定を制御します。
          </para>
@z

@x busctl
          <para>Introspects and monitors the D-Bus bus</para>
@y
          <para>
          D-Bus のバス監視を行います。
          </para>
@z

@x halt
          <para>Halts, powers off, or reboots the machine</para>
@y
          <para>
          マシンの停止、電源オフ、再起動を行います。
          </para>
@z

@x hostnamectl
          <para>Controls the system hostname</para>
@y
          <para>
          システムホスト名を制御します。
          </para>
@z

@x init
          <para>systemd system and service manager</para>
@y
          <para>
          systemd のシステムサービスマネージャー。
          </para>
@z

@x journalctl
          <para>Queries the systemd journal</para>
@y
          <para>
          systemd の Journal の内容を確認します。
          </para>
@z

@x kernel-install
          <para>Adds and removes kernel and initramfs images to and from
          <filename class="directory">/boot</filename></para>
@y
          <para>
          カーネルや initramfs イメージを <filename class="directory">/boot</filename> ディレクトリに対して追加、削除します。
          </para>
@z

@x localectl
          <para>Controls the system locale and keyboard layout settings</para>
@y
          <para>
          システムロケールやキーボードレイアウト設定を制御します。
          </para>
@z

@x loginctl
          <para>Controls the systemd login manager</para>
@y
          <para>
          systemd のログインマネージャーを制御します。
          </para>
@z

@x machinectl
          <para>Controls the systemd machine manager</para>
@y
          <para>
          systemd のマシンマネージャーを制御します。
          </para>
@z

@x poweroff
          <para>Halts, powers off, or reboots the machine</para>
@y
          <para>
          マシンの停止、電源オフ、再起動を行います。
          </para>
@z

@x reboot
          <para>Halts, powers off, or reboots the machine</para>
@y
          <para>
          マシンの停止、電源オフ、再起動を行います。
          </para>
@z

@x runlevel
          <para>Prints previous and current SysV runlevel</para>
@y
          <para>
          前回および現在の SysV ランレベルを表示します。
          </para>
@z

@x shutdown
          <para>Halts, powers off, or reboots the machine</para>
@y
          <para>
          マシンの停止、電源オフ、再起動を行います。
          </para>
@z

@x systemctl
          <para>Control the systemd system and service manager</para>
@y
          <para>
          systemd のシステムサービスマネージャーを制御します。
          </para>
@z

@x systemd
          <para>System and service manager for Linux</para>
@y
          <para>
          Linux におけるシステムサービスマネージャー。
          </para>
@z

@x systemd-analyze
          <para>Analyzes system boot-up permformance</para>
@y
          <para>
          起動処理パフォーマンスを解析します。
          </para>
@z

@x systemd-ask-password
          <para>Queries the user for a system passphrase, via the
          TTY or an UI agent.</para>
@y
          <para>
          TTY や UI エージェントを通じてユーザーに対するシステムパスフレーズを問い合わせます。
          </para>
@z

@x systemd-cat
          <para>Connects a pipeline or program's output with the journal</para>
@y
          <para>
          パイプラインあるいはプログラム出力を systemd ジャーナルに接続します。
          </para>
@z

@x systemd-cgls
          <para>Recursively shows control group contents</para>
@y
          <para>
          コントロールグループ (control group) の内容を再帰的に表示します。
          </para>
@z

@x systemd-cgtop
          <para>Shows top control groups by resource usage</para>
@y
          <para>
          最上位のコントロールグループをリソース利用状況とともに表示します。
          </para>
@z

@x systemd-coredumpctl
          <para>Retrieves coredumps from the journal</para>
@y
          <para>
          ジャーナルからコアダンプを抽出します。
          </para>
@z

@x systemd-delta
          <para>Finds overridden configuration files</para>
@y
          <para>
          オーバーライドされた設定ファイルを検索します。
          </para>
@z

@x systemd-detect-virt
          <para>Detects execution in a virtual environment</para>
@y
          <para>
          仮想化環境での実行を検出します。
          </para>
@z

@x systemd-inhibit
          <para>Executes a program with an inhibition lock taken</para>
@y
          <para>
          禁止ロックをつけてプログラムを実行します。
          </para>
@z

@x systemd-machine-id-setup
          <para>Initializes the machine ID in
          <filename>/etc/machine-id</filename></para>
@y
          <para>
          <filename>/etc/machine-id</filename> ファイル内のマシンIDを初期化します。
          </para>
@z

@x systemd-notify
          <para>Notifies init system about start-up completion and other daemon
          status changes</para>
@y
          <para>
          init システムに対して、スタートアップが完了したことやデーモンのステータスが変更したことを通知します。
          </para>
@z

@x systemd-nspawn
          <para>Spawns a namespace container for debugging, testing, and
          building</para>
@y
          <para>
          デバッグ、テスト、ビルド作業のために名前空間コンテナー (namespace container) を起動します。
          </para>
@z

@x systemd-run
          <para>Runs programs in transient scope or service units</para>
@y
          <para>
          一時的なスコープや .scope ユニットによりプログラムを実行します。
          </para>
@z

@x systemd-stdio-bridge
          <para>Connects stdio or a socket to a given bus address</para>
@y
          <para>
          標準入出力あるいはソケットを指定されたバスアドレスに接続します。
          </para>
@z

@x systemd-tmpfiles
          <para>Creates, deletes, and cleans up volatile and temporary files</para>
@y
          <para>
          一時ファイルを生成、削除、クリーンアップします。
          </para>
@z

@x systemd-tty-ask-password-agent
          <para>Process system password requests</para>
@y
          <para>
          システムパスワードへの指示を処理します。
          </para>
@z

@x telinit
          <para>Tells <command>init</command> which run-level to change to</para>
@y
          <para>
          <command>init</command> コマンドに対してランレベルを何にするかを指示します。
          </para>
@z

@x timedatectl
          <para>Controls the system time and date</para>
@y
          <para>
          システムの日付時刻を制御します。
          </para>
@z

@x udevadm
          <para>Udev management tool</para>
@y
          <para>
          Udev 管理ツール。
          </para>
@z

@x libnss_myhostname
          <para>Plugin for the GNU Name Service Switch (NSS) functionality
          of Glibc, provding hostname resolution for the locally configured
          system hostname</para>
@y
          <para>
          Glibc における GNU ネームサービススイッチ (Name Service Switch; NSS) のプラグイン。
          ローカル内に設定されたシステムホスト名の名前解決を行います。
          </para>
@z

@x libsystemd
          <para>Support library for systemd</para>
@y
          <para>
          systemd に対するサポートライブラリ。
          </para>
@z

@x libudev
          <para>A library interface to Udev device information.</para>
@y
          <para>
          Udev デバイス情報に対するインターフェースライブラリ。
          </para>
@z