%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Bootscripts for CLFS &bootscripts-clfs-version;</title>
@y
  <title>CLFS &bootscripts-clfs-version; 用の Bootscripts</title>
@z

@x
    <para>The Bootscripts package contains a set of scripts to
    start/stop the CLFS system at bootup/shutdown.</para>
@y
    <para>
    Bootscripts パッケージは CLFS システムの起動、終了とともに実行する一連のスクリプトを提供します。 
    </para>
@z

@x
    <title>Installation of Bootscripts</title>
@y
    <title>&InstallationOf1;Bootscripts &InstallationOf2;</title>
@z

@x
    <para os="a">Install the bootscripts:</para>
@y
    <para os="a">&InstallThePackage;</para>
@z

@x
    <para os="c">If you are going to use a network card, run the following
    command to install scripts for starting and configuring the network
    interface:</para>
@y
    <para os="c">
    ネットワークカードを利用する場合は以下のコマンドを実行します。
    これによりネットワークインターフェースの起動や設定を行うスクリプトをインストールします。
    </para>
@z

@x
    <title>Contents of Bootscripts</title>
@y
    <title>&ContentsOf1;Bootscripts &ContentsOf2;</title>
@z

@x
      <segtitle>Installed scripts</segtitle>
@y
      <segtitle>&InstalledScripts;</segtitle>
@z

@x
        <seg>checkfs, cleanfs, console, functions, halt, ifdown,
        ifup, localnet, mountfs, mountkernfs, network, rc, reboot, sendsignals,
        setclock, static, swap, sysklogd, template, and udev.</seg>
@y
        <seg>checkfs, cleanfs, console, functions, halt, ifdown,
        ifup, localnet, mountfs, mountkernfs, network, rc, reboot, sendsignals,
        setclock, static, swap, sysklogd, template, and udev.</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x checkfs
          <para>Checks the integrity of the file systems before they are
          mounted (with the exception of journal and network based file
          systems)</para>
@y
          <para>
          ファイルシステムがマウントされる前にその整合性をチェックします。
          (ただしジャーナルファイルシステムとネットワークベースのファイルシステムは除きます。)
          </para>
@z

@x cleanfs
          <para>Removes files that should not be preserved between reboots,
          such as those in <filename class="directory">/run/</filename>
          and <filename class="directory">/var/lock/</filename>; it re-creates
          <filename>/run/utmp</filename> and removes the possibly present
          <filename>/etc/nologin</filename>, <filename>/fastboot</filename>,
          and <filename>/forcefsck</filename> files</para>
@y
          <para>
          リブートの際に不要となるファイルを削除します。
          例えば <filename class="directory">/run/</filename> ディレクトリや <filename
          class="directory">/var/lock/</filename> ディレクトリの配下にあるファイルです。
          <filename>/run/utmp</filename> ファイルは再生成されます。
          また <filename>/etc/nologin</filename>、<filename>/fastboot</filename>、<filename>/forcefsck</filename> がおそらく存在しており、これらは削除されます。
          </para>
@z

@x console
          <para>Loads the correct keymap table for the desired keyboard
          layout; it also sets the screen font</para>
@y
          <para>
          必要となるキーボードレイアウトに対しての正しいキーマップテーブルをロードします。
          同時にスクリーンフォントもセットします。
          </para>
@z

@x functions
          <para>Contains common functions, such as error and status checking,
          that are used by several bootscripts</para>
@y
          <para>
          共通的な関数を提供します。
          例えばエラーやステータスのチェックなどであり、これはブートスクリプトの多くが利用します。
          </para>
@z

@x halt
          <para>Halts the system</para>
@y
          <para>
          システムを停止します。
          </para>
@z

@x ifdown
          <para>Assists the network script with stopping network devices</para>
@y
          <!--
          日本語訳註: matsuand
          assists は訳から除外した。
          ifdown が上位のスクリプトで下位スクリプトを集めて全体で
          ネットワークデバイス停止を行うことから "支援、補助 (assist)する"
          と表わしているものと解釈。これを訳すと回りくどくなる。
          -->
          <para>
          ネットワークデバイスを停止するネットワークスクリプトです。
          </para>
@z

@x ifup
          <para>Assists the network script with starting network devices</para>
@y
          <!--
          日本語訳註: matsuand
          ifdown 同様。
          -->
          <para>
          ネットワークデバイスを起動するネットワークスクリプトです。
          </para>
@z

@x localnet
          <para>Sets up the system's hostname and local loopback device</para>
@y
          <para>
          システムのホスト名とローカルループバックデバイスを設定します。
          </para>
@z

@x mountfs
          <para>Mounts all file systems, except ones that are marked
          <emphasis>noauto</emphasis> or are network based</para>
@y
          <para>
          ファイルシステムをすべてマウントします。
          ただし <emphasis>noauto</emphasis> が設定されているものやネットワークベースのファイルシステムは除きます。
          </para>
@z

@x mountkernfs
          <para>Mounts virtual kernel file systems, such as
          <systemitem class="filesystem">proc</systemitem></para>
@y
          <para>
          仮想カーネルファイルシステムをマウントします。
          例えば <systemitem class="filesystem">proc</systemitem> などです。
          </para>
@z

@x network
          <para>Sets up network interfaces, such as network cards, and sets up
          the default gateway (where applicable)</para>
@y
          <para>
          ネットワークカードなどのネットワークインターフェースを設定します。
          そして (可能であれば) デフォルトゲートウェイを設定します。
          </para>
@z

@x rc
          <para>The master run-level control script; it is responsible for
          running all the other bootscripts one-by-one, in a sequence
          determined by the name of the symbolic links being processed</para>
@y
          <para>
          ランレベルを制御するマスタースクリプト。
          他のブートスクリプトを一つずつ実行します。
          その際には実行されるシンボリックの名前によって実行順序を決定します。
          </para>
@z

@x reboot
          <para>Reboots the system</para>
@y
          <para>
          システムを再起動します。
          </para>
@z

@x sendsignals
          <para>Makes sure every process is terminated before the system reboots
          or halts</para>
@y
          <para>
          システムが再起動または停止する前に、プロセスすべてが停止していることを確認します。
          </para>
@z

@x setclock
          <para>Resets the kernel clock to local time in case the hardware clock
          is not set to UTC time</para>
@y
          <para>
          ハードウェアクロックが UTC 時刻に設定されていなければ、カーネルクロックをローカル時刻としてリセットします。
          </para>
@z

@x static
          <para>Provides the functionality needed to assign a static Internet
          Protocol (IP) address to a network interface</para>
@y
          <para>
          ネットワークインターフェースに対してスタティック IP アドレスを割り当てるために必要な機能を提供します。
          </para>
@z

@x swap
          <para>Enables and disables swap files and partitions</para>
@y
          <para>
          スワップファイルやスワップパーティションを有効または無効にします。
          </para>
@z

@x sysklogd
          <para>Starts and stops the system and kernel log daemons</para>
@y
          <para>
          システムおよびカーネルのログデーモンを起動あるいは停止します。
          </para>
@z

@x template
          <para>A template to create custom bootscripts for other
          daemons</para>
@y
          <para>
          他のデーモン用にカスタマイズしたブートスクリプトを生成するためのテンプレート。
          </para>
@z

@x udev
          <para>Starts and stops the Eudev daemon</para>
@y
          <para>
          Eudev デーモンの起動、停止を行います。
          </para>
@z