%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Configuring the system clock</title>
@y
  <title>システムクロックの設定</title>
@z

@x
  <secondary>configuring</secondary></indexterm>
@y
  <secondary>設定</secondary></indexterm>
@z

@x
  <para>This section discusses how to configure the
  <command>systemd-timedated</command> system service, which configures
  system clock and timezone.</para>
@y
  <para>
  本節ではシステムサービス <command>systemd-timedated</command> の設定方法について示します。
  このサービスはシステムクロックとタイムゾーンの設定を行うものです。
  </para>
@z

@x
  <para>Systemd provides a <command>timedatectl</command> utility which is
  used to communicate with <command>systemd-timedated</command>. It can be used
  to set the system clock in local time or UTC time, depending on the hardware
  clock setting. By default, <command>systemd-timedated</command> will assume
  that clock is set to UTC time.</para>
@y
  <para>
  Systemd は <command>timedatectl</command> ユーティリティーを提供します。
  これは <command>systemd-timedated</command> サービスとのやりとりに用いられます。
  例えばハードウェアクロックの設定に応じてシステムクロックをローカル時刻または UTC 時刻に設定することができます。
  <command>systemd-timedated</command> はデフォルトではシステムクロックが UTC に設定されているものとしています。
  </para>
@z

@x
  <para>If you cannot remember whether or not the hardware clock is set to UTC,
  find out by running the <userinput>hwclock --localtime --show</userinput>
  command. This will display what the current time is according to the hardware
  clock. If this time matches whatever your watch says, then the hardware clock is
  set to local time. If the output from <command>hwclock</command> is not local
  time, chances are it is set to UTC time. Verify this by adding or subtracting
  the proper amount of hours for the timezone to the time shown by
  <command>hwclock</command>. For example, if you are currently in the MST
  timezone, which is also known as GMT -0700, add seven hours to the local
  time.</para>
@y
  <para>
  ハードウェアクロックが UTC に設定されているかどうか忘れた場合は <userinput>hwclock --localtime --show</userinput> を実行すれば確認できます。
  このコマンドにより、ハードウェアクロックに基づいた現在時刻が表示されます。
  その時刻が手元の時計と同じ時刻であれば、ローカル時刻として設定されているわけです。
  一方それがローカル時刻でなかった場合は、おそらくは UTC に設定されているからでしょう。
  <command>hwclock</command> によって示された時刻からタイムゾーンに応じた一定時間を加減してみてください。
  例えばタイムゾーンが MST であった場合、これは GMT -0700 なので、7時間を加えればローカル時刻となります。
  </para>
@z

@x
  <para><command>systemd-timedated</command> reads
  <filename>/etc/adjtime</filename>, and depending on the contents of the file,
  it sets the clock to either UTC or local time.</para>
@y
  <para>
  <command>systemd-timedated</command> コマンドは <filename>/etc/adjtime</filename> ファイルを読み込みます。
  そしてこのファイルの設定内容に応じて、システムクロックを UTC かあるいはローカル時刻に設定します。
  </para>
@z

@x
 <para>Create the <filename>/etc/adjtime</filename> file with the following
 contents if your hardware clock is set to local time:</para>
@y
  <para>
  ハードウェアクロックをローカル時刻に設定する場合は、以下の内容により <filename>/etc/adjtime</filename> ファイルを生成します。
  </para>
@z

@x
 <para>If <filename>/etc/adjtime</filename> isn't present at first boot,
 <command>systemd-timedated</command> will assume that hardware clock is
 set to UTC and adjust the file according to that.</para>
@y
  <para>
  起動時に <filename>/etc/adjtime</filename> ファイルが存在しなかった場合、ハードウェアクロックは UTC に設定されているものとして <command>systemd-timedated</command> が判断し、このファイルを調整します。
  </para>
@z

@x
  <para>If your clock is set to local time, tell
  <command>systemd-timedated</command> about it by running the following
  command:</para>
@y
  <para>
  ローカル時刻に設定している場合、以下のコマンドを実行すれば <command>systemd-timedated</command> によりその設定が反映されます。
  </para>
@z

@x
  <para><command>timedatectl</command> can also be used to change system time and
  time zone.</para>
@y
  <para>
  <command>timedatectl</command> コマンドを用いれば、システム時刻やタイムゾーンを変更することもできます。
  </para>
@z

@x
  <para>To change your current system time, issue:</para>
@y
  <para>
  システム時刻を変更するには以下を実行します。
  </para>
@z

@x
  <para>Hardware clock will also be updated accordingly.</para>
@y
  <para>
  ハードウェアクロックも同様に設定することができます。
  </para>
@z

@x
  <para>To change your current time zone, issue:</para>
@y
  <para>
  タイムゾーンを変更するには以下を実行します。
  </para>
@z

@x
  <para>You can get list of available time zones by running:</para>
@y
  <para>
  利用可能なタイムゾーンの一覧は以下を実行して確認できます。
  </para>
@z

@x
  <note><para>Please note that <command>timedatectl</command> command can
  be used only on a system booted with systemd.</para></note>
@y
  <note><para>
  <command>timedatectl</command> コマンドはあくまで systemd により起動されたシステムにおいて利用できる点に注意してください。
  </para></note>
@z