/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.IClusterable;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.util.lang.Classes;

public abstract class MetaDataKey
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final String typeName;

    public MetaDataKey(Class type) {
        this.typeName = type.getName();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().isInstance(obj);
    }

    Object get(MetaDataEntry[] metaData) {
        if (metaData != null) {
            for (int i = 0; i < metaData.length; ++i) {
                MetaDataEntry m = metaData[i];
                if (!this.equals(m.key)) continue;
                return m.object;
            }
        }
        return null;
    }

    MetaDataEntry[] set(MetaDataEntry[] metaData, Object object) {
        this.checkType(object);
        boolean set = false;
        if (metaData != null) {
            for (int i = 0; i < metaData.length; ++i) {
                MetaDataEntry m = metaData[i];
                if (!this.equals(m.key)) continue;
                if (object != null) {
                    m.object = object;
                } else if (metaData.length > 1) {
                    int l = metaData.length - 1;
                    MetaDataEntry[] newMetaData = new MetaDataEntry[l];
                    System.arraycopy(metaData, 0, newMetaData, 0, i);
                    System.arraycopy(metaData, i + 1, newMetaData, i, l - i);
                    metaData = newMetaData;
                } else {
                    metaData = null;
                    break;
                }
                set = true;
            }
        }
        if (!set && object != null) {
            MetaDataEntry m = new MetaDataEntry(this, object);
            if (metaData == null) {
                metaData = new MetaDataEntry[]{m};
            } else {
                MetaDataEntry[] newMetaData = new MetaDataEntry[metaData.length + 1];
                System.arraycopy(metaData, 0, newMetaData, 0, metaData.length);
                newMetaData[metaData.length] = m;
                metaData = newMetaData;
            }
        }
        return metaData;
    }

    void checkType(Object object) {
        Class clazz = Classes.resolveClass(this.typeName);
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("MetaDataKey " + this.getClass() + " requires argument of " + clazz + ", not " + object.getClass());
        }
    }

    public String toString() {
        return this.getClass() + "[type=" + this.typeName + "]";
    }
}

