/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.SharedResources;
import org.apache.wicket.markup.html.CompressedPackageResource;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.JavascriptStripper;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptPackageResource
extends CompressedPackageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)JavascriptPackageResource.class);

    public static PackageResource get(Class scope, String path, Locale locale, String style) {
        SharedResources sharedResources = Application.get().getSharedResources();
        PackageResource resource = (PackageResource)sharedResources.get(scope, path, locale, style, true);
        if (resource == null) {
            resource = new JavascriptPackageResource(scope, path, locale, style);
            sharedResources.add(scope, path, locale, style, resource);
        }
        return resource;
    }

    public JavascriptPackageResource(Class scope, String path, Locale locale, String style) {
        super(scope, path, locale, style);
    }

    protected IResourceStream newResourceStream() {
        final FilteringResourceStream filteringStream = new FilteringResourceStream(){
            private static final long serialVersionUID = 1L;

            protected byte[] filterContent(byte[] input) {
                try {
                    if (Application.get().getResourceSettings().getStripJavascriptCommentsAndWhitespace()) {
                        String s = new String(input, "UTF-8");
                        return JavascriptStripper.stripCommentsAndWhitespace(s).getBytes("UTF-8");
                    }
                    return input;
                }
                catch (Exception e) {
                    log.error("Error while filtering content", (Throwable)e);
                    return input;
                }
            }

            protected IResourceStream getOriginalResourceStream() {
                return JavascriptPackageResource.this.getPackageResourceStream();
            }
        };
        return new CompressedPackageResource.CompressingResourceStream(){
            private static final long serialVersionUID = 1L;

            protected IResourceStream getOriginalResourceStream() {
                return filteringStream;
            }
        };
    }

    protected abstract class FilteringResourceStream
    implements IResourceStream {
        private static final long serialVersionUID = 1L;
        private SoftReference cache = new SoftReference<Object>(null);
        private Time timeStamp = null;

        protected FilteringResourceStream() {
        }

        public void close() throws IOException {
        }

        public String getContentType() {
            return this.getOriginalResourceStream().getContentType();
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            return new ByteArrayInputStream(this.getFilteredContent());
        }

        public Locale getLocale() {
            return this.getOriginalResourceStream().getLocale();
        }

        public Time lastModifiedTime() {
            return this.getOriginalResourceStream().lastModifiedTime();
        }

        public long length() {
            return this.getFilteredContent().length;
        }

        public void setLocale(Locale locale) {
            this.getOriginalResourceStream().setLocale(locale);
        }

        private byte[] getFilteredContent() {
            IResourceStream stream = this.getOriginalResourceStream();
            try {
                byte[] ret = (byte[])this.cache.get();
                if (ret != null && this.timeStamp != null && this.timeStamp.equals(stream.lastModifiedTime())) {
                    return ret;
                }
                int length = (int)stream.length();
                ByteArrayOutputStream out = new ByteArrayOutputStream(length > 0 ? length : 0);
                Streams.copy(stream.getInputStream(), out);
                stream.close();
                ret = this.filterContent(out.toByteArray());
                this.timeStamp = stream.lastModifiedTime();
                this.cache = new SoftReference<byte[]>(ret);
                return ret;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract byte[] filterContent(byte[] var1);

        protected abstract IResourceStream getOriginalResourceStream();
    }
}

