/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketURLEncoder {
    private static final Logger log = LoggerFactory.getLogger((Class)Application.class);
    private static final int QUERY = 1;
    private static final int PATH = 2;
    protected BitSet dontNeedEncoding = new BitSet(256);
    protected static final int caseDiff = 32;
    public static final WicketURLEncoder QUERY_INSTANCE = new WicketURLEncoder(1);
    public static final WicketURLEncoder PATH_INSTANCE = new WicketURLEncoder(2);

    protected WicketURLEncoder(int type) {
        int i;
        for (i = 97; i <= 122; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            this.dontNeedEncoding.set(i);
        }
        this.dontNeedEncoding.set(45);
        this.dontNeedEncoding.set(46);
        this.dontNeedEncoding.set(95);
        this.dontNeedEncoding.set(126);
        this.dontNeedEncoding.set(33);
        this.dontNeedEncoding.set(36);
        this.dontNeedEncoding.set(39);
        this.dontNeedEncoding.set(42);
        this.dontNeedEncoding.set(44);
        this.dontNeedEncoding.set(58);
        this.dontNeedEncoding.set(64);
        switch (type) {
            case 1: {
                this.dontNeedEncoding.set(32);
                this.dontNeedEncoding.set(47);
                this.dontNeedEncoding.set(63);
                break;
            }
            case 2: {
                this.dontNeedEncoding.set(38);
                this.dontNeedEncoding.set(61);
                this.dontNeedEncoding.set(43);
            }
        }
    }

    public String encode(String s) {
        Application app = null;
        try {
            app = Application.get();
        }
        catch (WicketRuntimeException ignored) {
            log.warn("No current Application found - defaulting encoding to UTF-8");
        }
        return this.encode(s, app == null ? "UTF-8" : app.getRequestCycleSettings().getResponseRequestEncoding());
    }

    public String encode(String s, String enc) {
        Charset charset;
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (enc == null) {
            throw new NullPointerException("charsetName");
        }
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException e) {
            throw new WicketRuntimeException(new UnsupportedEncodingException(enc));
        }
        catch (UnsupportedCharsetException e) {
            throw new WicketRuntimeException(new UnsupportedEncodingException(enc));
        }
        int i = 0;
        while (i < s.length()) {
            char c;
            int c2 = s.charAt(i);
            if (this.dontNeedEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                    needToChange = true;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= s.length()) break;
                c = s.charAt(i);
                c2 = c;
            } while (!this.dontNeedEncoding.get(c));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = new byte[]{};
            try {
                ba = str.getBytes(charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new WicketRuntimeException(e);
            }
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }
}

