/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javax.context.Context;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -5391564935097267888L;
    private static transient LogProvider log = Logging.getLogProvider(ClientProxyMethodHandler.class);
    private transient Bean<?> bean;
    private final int beanIndex;
    private final ManagerImpl manager;
    private static final ThreadLocal<CreationalContextImpl<?>> currentCreationalContext = new ThreadLocal();

    public ClientProxyMethodHandler(Bean<?> bean, ManagerImpl manager, int beanIndex) {
        this.bean = bean;
        this.beanIndex = beanIndex;
        this.manager = manager;
        log.trace("Created method handler for bean " + bean + " indexed as " + beanIndex);
    }

    @Override
    public Object invoke(Object self, Method proxiedMethod, Method proceed, Object[] args) throws Throwable {
        if (this.bean == null) {
            this.bean = this.manager.getBeans().get(this.beanIndex);
        }
        Object proxiedInstance = this.getProxiedInstance(this.bean);
        Object returnValue = Reflections.lookupMethod(proxiedMethod, proxiedInstance).invoke(proxiedInstance, args);
        log.trace("Executed method " + proxiedMethod + " on " + proxiedInstance + " with parameters " + args + " and got return value " + returnValue);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getProxiedInstance(Bean<T> bean) {
        CreationalContextImpl<T> creationalContext;
        if (currentCreationalContext.get() == null) {
            creationalContext = new CreationalContextImpl<T>(bean);
            currentCreationalContext.set(creationalContext);
        } else {
            creationalContext = currentCreationalContext.get().getCreationalContext(bean);
        }
        try {
            Context context = this.manager.getContext(bean.getScopeType());
            T t = context.get(bean, creationalContext);
            return t;
        }
        finally {
            if (creationalContext.isOuter()) {
                currentCreationalContext.remove();
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String beanInfo = this.bean == null ? "null bean" : this.bean.toString();
        buffer.append("Proxy method handler for " + beanInfo + " with index " + this.beanIndex);
        return buffer.toString();
    }
}

