/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.NewBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.injection.resolution.ResolvableAnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private static final AnnotatedItem<?, ?> OTHER_BEANS_ANNOTATED_ITEM = ResolvableAnnotatedClass.of(BeanDeployerEnvironment.class, new Annotation[0]);
    private final Map<AnnotatedClass<?>, AbstractClassBean<?>> classBeanMap = new HashMap();
    private final Map<AnnotatedMethod<?>, ProducerMethodBean<?>> producerMethodBeanMap = new HashMap();
    private final Map<AnnotatedMethod<?>, DisposalMethodBean<?>> disposalMethodBeanMap = new HashMap();
    private final Set<RIBean<?>> beans;
    private final Set<ObserverImpl<?>> observers;
    private final Set<DisposalMethodBean<?>> allDisposalBeans = new HashSet();
    private final Set<DisposalMethodBean<?>> resolvedDisposalBeans = new HashSet();
    private final EjbDescriptorCache ejbDescriptors;

    public BeanDeployerEnvironment(EjbDescriptorCache ejbDescriptors) {
        this.beans = new HashSet();
        this.observers = new HashSet();
        this.ejbDescriptors = ejbDescriptors;
    }

    public ProducerMethodBean<?> getProducerMethod(AnnotatedMethod<?> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        ProducerMethodBean<?> bean = this.producerMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public DisposalMethodBean<?> getDisposalMethod(AnnotatedMethod<?> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        DisposalMethodBean<?> bean = this.disposalMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public AbstractClassBean<?> getClassBean(AnnotatedClass<?> clazz) {
        if (!this.classBeanMap.containsKey(clazz)) {
            return null;
        }
        AbstractClassBean<?> bean = this.classBeanMap.get(clazz);
        bean.initialize(this);
        return bean;
    }

    public void addBean(RIBean<?> value) {
        if (value instanceof AbstractClassBean && !(value instanceof NewBean)) {
            AbstractClassBean bean = (AbstractClassBean)value;
            this.classBeanMap.put((AnnotatedClass<?>)bean.getAnnotatedItem(), bean);
        } else if (value instanceof ProducerMethodBean) {
            ProducerMethodBean bean = (ProducerMethodBean)value;
            this.producerMethodBeanMap.put((AnnotatedMethod<?>)bean.getAnnotatedItem(), bean);
        } else if (value instanceof DisposalMethodBean) {
            DisposalMethodBean bean = (DisposalMethodBean)value;
            this.disposalMethodBeanMap.put((AnnotatedMethod<?>)bean.getAnnotatedItem(), bean);
        }
        this.beans.add(value);
    }

    public Set<RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<ObserverImpl<?>> getObservers() {
        return this.observers;
    }

    public Set<DisposalMethodBean<?>> getAllDisposalBeans() {
        return this.allDisposalBeans;
    }

    public void addAllDisposalBean(DisposalMethodBean<?> disposalBean) {
        this.allDisposalBeans.add(disposalBean);
    }

    public void addResolvedDisposalBean(DisposalMethodBean<?> disposalBean) {
        this.resolvedDisposalBeans.add(disposalBean);
    }

    public Set<DisposalMethodBean<?>> getResolvedDisposalBeans() {
        return this.resolvedDisposalBeans;
    }

    public EjbDescriptorCache getEjbDescriptors() {
        return this.ejbDescriptors;
    }
}

