/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.TypeLiteral;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableAnnotatedClass<T>
extends AbstractAnnotatedItem<T, Class<T>> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final String _string;

    public static <T> ResolvableAnnotatedClass<T> of(TypeLiteral<T> typeLiteral, Annotation[] annotations) {
        return new ResolvableAnnotatedClass<T>(typeLiteral.getRawType(), typeLiteral.getType(), annotations);
    }

    public static <T> ResolvableAnnotatedClass<T> of(Class<T> clazz, Annotation[] annotations) {
        return new ResolvableAnnotatedClass<T>(clazz, clazz, annotations);
    }

    public static <T> ResolvableAnnotatedClass<T> of(Type type, Annotation[] annotations) {
        if (type instanceof Class) {
            return new ResolvableAnnotatedClass<T>((Class)type, type, annotations);
        }
        if (type instanceof ParameterizedType) {
            return new ResolvableAnnotatedClass<T>((Class)((ParameterizedType)type).getRawType(), type, annotations);
        }
        throw new UnsupportedOperationException("Cannot create annotated item of " + type);
    }

    public static <T> ResolvableAnnotatedClass<T> of(Member member, Annotation[] annotations) {
        if (member instanceof Field) {
            return new ResolvableAnnotatedClass(((Field)member).getType(), ((Field)member).getGenericType(), annotations);
        }
        if (member instanceof Method) {
            return new ResolvableAnnotatedClass(((Method)member).getReturnType(), ((Method)member).getGenericReturnType(), annotations);
        }
        throw new IllegalStateException();
    }

    private ResolvableAnnotatedClass(Class<T> rawType, Type type, Annotation[] annotations) {
        super(AnnotationStore.of(annotations, EMPTY_ANNOTATION_ARRAY));
        this.rawType = rawType;
        if (type instanceof ParameterizedType) {
            this.actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            this._string = rawType.toString() + "<" + Arrays.asList(this.actualTypeArguments).toString() + ">; binding types = " + Names.annotationsToString(new HashSet<Annotation>(Arrays.asList(annotations)));
        } else {
            this.actualTypeArguments = new Type[0];
            this._string = rawType.toString() + "; binding types = " + Names.annotationsToString(new HashSet<Annotation>(Arrays.asList(annotations)));
        }
    }

    @Override
    public String toString() {
        return this._string;
    }

    @Override
    public Class<T> getDelegate() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<T> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getType() {
        return this.getRawType();
    }

    @Override
    public boolean isFinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPublic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Type> getFlattenedTypeHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxyable() {
        throw new UnsupportedOperationException();
    }
}

