/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertMappingConsumer
implements MappingConsumer {
    private final Set<JavaTypeMapping> externalFKMappings = new HashSet<JavaTypeMapping>();
    private final Set<JavaTypeMapping> externalOrderMappings = new HashSet<JavaTypeMapping>();
    private final List<MappingCallbacks> mc = new ArrayList<MappingCallbacks>();
    private AbstractMemberMetaData parentMapping = null;
    private final AbstractClassMetaData cmd;

    public InsertMappingConsumer(AbstractClassMetaData cmd) {
        this.cmd = cmd;
    }

    public void preConsumeMapping(int highestFieldNumber) {
    }

    public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
            return;
        }
        if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof ReferenceMapping)) {
            if (fmd.hasExtension("insertable") && fmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                return;
            }
            ColumnMetaData[] colmds = fmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                for (ColumnMetaData colmd : colmds) {
                    if (colmd.getInsertable()) continue;
                    return;
                }
            }
        }
        if (m instanceof MappingCallbacks) {
            this.mc.add((MappingCallbacks)m);
        }
    }

    public void consumeMapping(JavaTypeMapping m, int mappingType) {
        if (mappingType == 5) {
            this.externalFKMappings.add(m);
        } else if (mappingType == 4) {
            this.externalOrderMappings.add(m);
        }
    }

    public void consumeUnmappedDatastoreField(DatastoreField fld) {
    }

    List<MappingCallbacks> getMappingCallbacks() {
        return this.mc;
    }

    Set<JavaTypeMapping> getExternalFKMappings() {
        return this.externalFKMappings;
    }

    Set<JavaTypeMapping> getExternalOrderMappings() {
        return this.externalOrderMappings;
    }

    AbstractMemberMetaData getParentMappingField() {
        return this.parentMapping;
    }

    void setParentMappingField(AbstractMemberMetaData parentMapping) {
        this.parentMapping = parentMapping;
    }
}

