/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.protocol.http.WebResponse;

public abstract class AutoCompleteBehavior
extends AbstractAutoCompleteBehavior {
    private static final long serialVersionUID = 1L;
    private final IAutoCompleteRenderer renderer;

    public AutoCompleteBehavior(IAutoCompleteRenderer renderer) {
        this(renderer, false);
    }

    public AutoCompleteBehavior(IAutoCompleteRenderer renderer, boolean preselect) {
        this(renderer, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteBehavior(IAutoCompleteRenderer renderer, AutoCompleteSettings settings) {
        if (renderer == null) {
            throw new IllegalArgumentException("renderer cannot be null");
        }
        if (settings == null) {
            settings = new AutoCompleteSettings();
        }
        this.renderer = renderer;
        this.settings = settings;
    }

    protected final void onRequest(final String val, RequestCycle requestCycle) {
        IRequestTarget target = new IRequestTarget(){

            public void respond(RequestCycle requestCycle) {
                WebResponse r = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                r.setCharacterEncoding(encoding);
                r.setContentType("text/xml; charset=" + encoding);
                r.setHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
                r.setHeader("Cache-Control", "no-cache, must-revalidate");
                r.setHeader("Pragma", "no-cache");
                Iterator comps = AutoCompleteBehavior.this.getChoices(val);
                AutoCompleteBehavior.this.renderer.renderHeader((Response)r);
                while (comps.hasNext()) {
                    Object comp = comps.next();
                    AutoCompleteBehavior.this.renderer.render(comp, (Response)r, val);
                }
                AutoCompleteBehavior.this.renderer.renderFooter((Response)r);
            }

            public void detach(RequestCycle requestCycle) {
            }
        };
        requestCycle.setRequestTarget(target);
    }

    protected abstract Iterator getChoices(String var1);
}

