/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.common.base.X;
import com.google.appengine.repackaged.com.google.common.base.genfiles.ObjectObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tracer {
    static final Logger logger_ = Logger.getLogger(Tracer.class.getName());
    final String type_;
    final String comment_;
    final long start_time_ms_;
    long stop_time_ms_;
    final Thread start_thread_;
    static final int MAX_TRACE_SIZE = 1000;
    private static Map<String, Long> typeToCountMap;
    private static Map<String, Long> typeToSilentMap;
    private static Map<String, Long> typeToTimeMap;
    private static final Stat ZERO_STAT;
    private static ThreadLocal<ThreadTrace> traces_;

    public Tracer(String type, String comment) {
        this.type_ = type;
        this.comment_ = comment == null ? "" : comment;
        this.start_time_ms_ = System.currentTimeMillis();
        this.start_thread_ = Thread.currentThread();
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            return;
        }
        if (trace.events_.size() >= 1000) {
            logger_.log(Level.WARNING, "Giant thread trace. Too many Tracers created. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateEvents();
        }
        if (trace.outstanding_events_.size() >= 1000) {
            logger_.log(Level.WARNING, "Too many outstanding Tracers. Tracer.stop() is missing or Tracer.stop() is not wrapped in a try/finally block. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateOutstandingEvents();
        }
        trace.startEvent(this);
    }

    public Tracer(String comment) {
        this(null, comment);
    }

    public static Tracer shortName(Object o, String comment) {
        if (o == null) {
            return new Tracer(comment);
        }
        String longName = "" + o;
        String[] parts = StringUtil.split(longName, ".");
        String lastPart = parts[parts.length - 1];
        String[] parts1 = StringUtil.split(lastPart, "@");
        return new Tracer(parts1[0], comment);
    }

    private static String longToPaddedString(long v) {
        String space = "";
        if (v < 1000L) {
            space = " ";
        }
        if (v < 100L) {
            space = "  ";
        }
        if (v < 10L) {
            space = "   ";
        }
        return space + v;
    }

    public long stop(int silence_threshold) {
        X.assertTrue(Thread.currentThread() == this.start_thread_);
        this.stop_time_ms_ = System.currentTimeMillis();
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            return 0L;
        }
        trace.endEvent(this, silence_threshold);
        return this.stop_time_ms_ - this.start_time_ms_;
    }

    public long stop() {
        return this.stop(-1);
    }

    public String toString() {
        if (this.type_ == null) {
            return this.comment_;
        }
        return "[" + this.type_ + "] " + this.comment_;
    }

    public static void setDefaultSilenceThreshold(int threshold) {
        Tracer.getThreadTrace().default_silence_threshold_ = threshold;
    }

    public static void initCurrentThreadTrace() {
        ThreadTrace events = Tracer.getThreadTrace();
        if (!events.isEmpty()) {
            logger_.log(Level.WARNING, "Non-empty timer log:\n" + events, new Throwable());
            Tracer.clearThreadTrace();
            events = Tracer.getThreadTrace();
        }
        events.init();
    }

    public static void initCurrentThreadTrace(int default_silence_threshold) {
        Tracer.initCurrentThreadTrace();
        Tracer.setDefaultSilenceThreshold(default_silence_threshold);
    }

    public static String getCurrentThreadTraceReport() {
        return Tracer.getThreadTrace().toString();
    }

    public static void logCurrentThreadTrace() {
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            logger_.log(Level.WARNING, "Tracer log requested for this thread but was not initialized using Tracer.initCurrentThreadTrace().", new Throwable());
            return;
        }
        if (!trace.isEmpty()) {
            logger_.log(Level.INFO, "timers:\n{0}", Tracer.getCurrentThreadTraceReport());
        }
    }

    public static void clearCurrentThreadTrace() {
        Tracer.clearThreadTrace();
    }

    public static void logAndClearCurrentThreadTrace() {
        Tracer.logCurrentThreadTrace();
        Tracer.clearThreadTrace();
    }

    public static synchronized void enableTypeMaps() {
        if (typeToCountMap != null) {
            throw new IllegalArgumentException("Cannot enableTypeMaps twice!");
        }
        typeToCountMap = new HashMap<String, Long>();
        typeToSilentMap = new HashMap<String, Long>();
        typeToTimeMap = new HashMap<String, Long>();
    }

    public static Map<String, Long> getTypeToCountMap() {
        return typeToCountMap;
    }

    public static Map<String, Long> getTypeToSilentMap() {
        return typeToSilentMap;
    }

    public static Map<String, Long> getTypeToTimeMap() {
        return typeToTimeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementMapBy(Map<String, Long> theMap, String key, long incBy) {
        if (theMap == null) {
            return;
        }
        Map<String, Long> map = theMap;
        synchronized (map) {
            if (theMap.containsKey(key)) {
                theMap.put(key, theMap.get(key) + incBy);
            } else {
                theMap.put(key, incBy);
            }
        }
    }

    public static Stat getStatsForType(String type) {
        Stat stat = (Stat)Tracer.getThreadTrace().stats_.lookup(type, null);
        return stat != null ? stat : ZERO_STAT;
    }

    private static String formatTime(long time) {
        int sec = (int)(time / 1000L % 60L);
        int ms = (int)(time % 1000L);
        return Integer.toString(100 + sec).substring(1, 3) + "." + Integer.toString(1000 + ms).substring(1, 4);
    }

    static ThreadTrace getThreadTrace() {
        ThreadTrace t = traces_.get();
        if (t == null) {
            t = new ThreadTrace();
            traces_.set(t);
        }
        return t;
    }

    static void clearThreadTrace() {
        traces_.set(null);
    }

    static {
        ZERO_STAT = new Stat();
        traces_ = new ThreadLocal();
    }

    static final class ThreadTrace {
        int default_silence_threshold_;
        final ArrayList<Event> events_ = new ArrayList();
        final HashSet<Tracer> outstanding_events_ = new HashSet();
        final ObjectObjectMap stats_ = new ObjectObjectMap();
        boolean isOutstandingEventsTruncated = false;
        boolean isEventsTruncated = false;
        boolean isInitialized = false;

        ThreadTrace() {
        }

        void init() {
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        void startEvent(Tracer t) {
            this.events_.add(new Event(true, t));
            boolean not_already_outstanding = this.outstanding_events_.add(t);
            X.assertTrue(not_already_outstanding);
        }

        void endEvent(Tracer t, int silence_threshold) {
            boolean was_outstanding = this.outstanding_events_.remove(t);
            if (!was_outstanding) {
                if (this.isOutstandingEventsTruncated) {
                    logger_.log(Level.WARNING, "event not found, probably because the event stack overflowed and was truncated", new Throwable());
                } else {
                    X.assertTrue(false);
                }
            }
            long elapsed = t.stop_time_ms_ - t.start_time_ms_;
            if (silence_threshold == -1) {
                silence_threshold = this.default_silence_threshold_;
            }
            if (elapsed < (long)silence_threshold) {
                boolean removed = false;
                for (int i = 0; i < this.events_.size(); ++i) {
                    Event e = this.events_.get(i);
                    if (e.tracer_ != t) continue;
                    X.assertTrue(e.is_start_);
                    this.events_.remove(i);
                    removed = true;
                    break;
                }
                X.assertTrue(removed || this.isEventsTruncated);
            } else {
                this.events_.add(new Event(false, t));
            }
            if (t.type_ != null) {
                Stat stat = (Stat)this.stats_.lookup(t.type_, null);
                if (stat == null) {
                    stat = new Stat();
                    this.stats_.insert(t.type_, stat);
                }
                stat.count_++;
                Tracer.incrementMapBy(typeToCountMap, t.type_, 1L);
                stat.time_ = (int)((long)stat.time_ + elapsed);
                Tracer.incrementMapBy(typeToTimeMap, t.type_, elapsed);
                if (elapsed < (long)silence_threshold) {
                    stat.silent_++;
                    Tracer.incrementMapBy(typeToSilentMap, t.type_, 1L);
                }
            }
        }

        boolean isEmpty() {
            return this.events_.size() == 0 && this.outstanding_events_.size() == 0;
        }

        void truncateOutstandingEvents() {
            this.isOutstandingEventsTruncated = true;
            this.outstanding_events_.clear();
        }

        void truncateEvents() {
            this.isEventsTruncated = true;
            this.events_.clear();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            long etime = -1L;
            for (Event e : this.events_) {
                sb.append(" ");
                sb.append(e.toString(etime));
                etime = e.eventTime();
                sb.append('\n');
            }
            if (this.outstanding_events_.size() != 0) {
                long now = System.currentTimeMillis();
                sb.append(" Unstopped timers:\n");
                for (Tracer t : this.outstanding_events_) {
                    sb.append("  ").append(t).append(" (").append(now - t.start_time_ms_).append(" ms, started at ").append(Tracer.formatTime(t.start_time_ms_)).append(")\n");
                }
            }
            int i = -1;
            while ((i = this.stats_.next(i)) >= 0) {
                Stat stat = (Stat)this.stats_.valueAt(i);
                if (stat.count_ <= 1) continue;
                sb.append(" TOTAL ").append(this.stats_.keyAt(i)).append(" ").append(stat.count_).append(" (").append(stat.time_).append(" ms)\n");
            }
            return sb.toString();
        }
    }

    private static final class Event {
        boolean is_start_;
        Tracer tracer_;

        Event(boolean start, Tracer t) {
            this.is_start_ = start;
            this.tracer_ = t;
        }

        long eventTime() {
            return this.is_start_ ? this.tracer_.start_time_ms_ : this.tracer_.stop_time_ms_;
        }

        String toString(long prev_event_time) {
            StringBuilder sb = new StringBuilder(120);
            if (prev_event_time == -1L) {
                sb.append("    ");
            } else {
                sb.append(Tracer.longToPaddedString(this.eventTime() - prev_event_time));
            }
            sb.append(' ');
            sb.append(Tracer.formatTime(this.eventTime()));
            if (this.is_start_) {
                sb.append(" Start        ");
            } else {
                sb.append(" Done ");
                long delta = this.tracer_.stop_time_ms_ - this.tracer_.start_time_ms_;
                sb.append(Tracer.longToPaddedString(delta));
                sb.append(" ms ");
            }
            sb.append(this.tracer_.toString());
            return sb.toString();
        }
    }

    public static final class Stat {
        private int count_;
        private int silent_;
        private int time_;

        public int getCount() {
            return this.count_;
        }

        public int getSilentCount() {
            return this.silent_;
        }

        public int getTotalTime() {
            return this.time_;
        }
    }
}

