/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;

public abstract class AjaxLink
extends AbstractLink
implements IAjaxLink {
    private static final long serialVersionUID = 1L;

    public AjaxLink(String id) {
        this(id, null);
    }

    public AjaxLink(String id, IModel model) {
        super(id, model);
        this.add(new AjaxEventBehavior("onclick"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                AjaxLink.this.onClick(target);
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new CancelEventIfNoAjaxDecorator(AjaxLink.this.getAjaxCallDecorator());
            }

            protected void onComponentTag(ComponentTag tag) {
                if (AjaxLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }
        });
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isLinkEnabled()) {
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", "#");
            }
        } else {
            this.disableLink(tag);
        }
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    public abstract void onClick(AjaxRequestTarget var1);
}

