/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.border;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IModel;

public abstract class Border
extends WebMarkupContainerWithAssociatedMarkup
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    static final String BODY = "body";
    static final String BORDER = "border";
    private boolean transparentResolver = false;
    private static final String BODY_ID = "_body";
    private BorderBodyContainer body = new BorderBodyContainer("_body");
    private transient MarkupStream originalMarkupStream;
    private transient ComponentTag openTag;
    private int beginOfBodyIndex;

    public Border(String id) {
        super(id);
        this.add(this.body);
    }

    public Border(String id, IModel model) {
        super(id, model);
        this.add(this.body);
    }

    public final BorderBodyContainer getBodyContainer() {
        if (this.body == null) {
            this.body = (BorderBodyContainer)this.get(BODY_ID);
        }
        return this.body;
    }

    public Border setBorderBodyVisible(boolean bodyVisible) {
        this.body.setVisible(false);
        return this;
    }

    public final Border setTransparentResolver(boolean enable) {
        this.transparentResolver = enable;
        return this;
    }

    public boolean isTransparentResolver() {
        return this.transparentResolver;
    }

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        MarkupContainer border;
        for (border = container.getParent(); border != null && !(border instanceof Border); border = border.getParent()) {
        }
        if (border == null || this == border) {
            return false;
        }
        if (!(border instanceof Border)) {
            return false;
        }
        if (!(tag instanceof WicketTag)) {
            return false;
        }
        WicketTag wtag = (WicketTag)tag;
        if (!wtag.isBodyTag()) {
            return false;
        }
        this.body.render(markupStream);
        return true;
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!tag.isOpen()) {
            throw new WicketRuntimeException("The border tag must be an open tag. Open-close is not allowed: " + tag.toString());
        }
        super.onComponentTag(tag);
    }

    protected final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.openTag = openTag;
        this.originalMarkupStream = this.getMarkupStream();
        this.beginOfBodyIndex = this.originalMarkupStream.getCurrentIndex();
        if (!this.isBodyVisible()) {
            this.originalMarkupStream.skipToMatchingCloseTag(openTag);
        }
        this.renderAssociatedMarkup(BORDER, "Markup for a border component must begin a tag like '<wicket:border>'");
    }

    private boolean isBodyVisible() {
        boolean bodyVisible = true;
        for (MarkupContainer cursor = this.body; cursor != this && bodyVisible; cursor = cursor.getParent()) {
            bodyVisible = cursor.determineVisibility();
        }
        return bodyVisible;
    }

    public void renderHead(HtmlHeaderContainer container) {
        this.renderHeadFromAssociatedMarkupFile(container);
        super.renderHead(container);
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName(BORDER);
        WicketTagIdentifier.registerWellKnownTagName(BODY);
    }

    public class BorderBodyContainer
    extends WebMarkupContainer
    implements IComponentResolver {
        private static final long serialVersionUID = 1L;
        private transient boolean wasOpenCloseTag;

        public BorderBodyContainer(String id) {
            super(id);
            this.wasOpenCloseTag = false;
        }

        protected void onComponentTag(ComponentTag tag) {
            if (tag.getType() == XmlTag.OPEN_CLOSE) {
                tag.setType(XmlTag.OPEN);
                tag.setModified(true);
                this.wasOpenCloseTag = true;
            }
            super.onComponentTag(tag);
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            if (!this.wasOpenCloseTag) {
                markupStream.skipRawMarkup();
            }
            if (Border.this.beginOfBodyIndex != Border.this.originalMarkupStream.getCurrentIndex()) {
                Border.this.originalMarkupStream.setCurrentIndex(Border.this.beginOfBodyIndex);
            }
            super.onComponentTagBody(Border.this.originalMarkupStream, Border.this.openTag);
        }

        public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
            Component component;
            String id = tag.getId();
            if (!id.equals(Border.BODY_ID) && (component = Border.this.get(id)) != null) {
                component.render(markupStream);
                return true;
            }
            return false;
        }
    }
}

