/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.list;

import java.util.List;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

public abstract class PageableListView
extends ListView
implements IPageable {
    private static final long serialVersionUID = 1L;
    private int currentPage;
    private int rowsPerPage;

    public PageableListView(String id, IModel model, int rowsPerPage) {
        super(id, model);
        this.rowsPerPage = rowsPerPage;
    }

    public PageableListView(String id, List list, int rowsPerPage) {
        super(id, list);
        this.rowsPerPage = rowsPerPage;
    }

    public final int getCurrentPage() {
        while (this.currentPage * this.rowsPerPage > this.getList().size()) {
            --this.currentPage;
        }
        return this.currentPage;
    }

    public final int getPageCount() {
        return (this.getList().size() + this.rowsPerPage - 1) / this.rowsPerPage;
    }

    public final int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public final void setRowsPerPage(int rowsPerPage) {
        if (rowsPerPage < 0) {
            rowsPerPage = 0;
        }
        this.addStateChange(new RowsPerPageChange(this.rowsPerPage));
        this.rowsPerPage = rowsPerPage;
    }

    public int getViewSize() {
        if (this.getModelObject() != null) {
            super.setStartIndex(this.getCurrentPage() * this.getRowsPerPage());
            super.setViewSize(this.getRowsPerPage());
        }
        return super.getViewSize();
    }

    public final void setCurrentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        }
        int pageCount = this.getPageCount();
        if (currentPage > 0 && currentPage >= pageCount) {
            currentPage = pageCount - 1;
        }
        this.addStateChange(new CurrentPageChange(this.currentPage));
        this.currentPage = currentPage;
    }

    public ListView setStartIndex(int startIndex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You must not use setStartIndex() with PageableListView");
    }

    public ListView setViewSize(int size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You must not use setViewSize() with PageableListView");
    }

    private class RowsPerPageChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final int rowsPerPage;

        RowsPerPageChange(int rowsPerPage) {
            this.rowsPerPage = rowsPerPage;
        }

        public void undo() {
            PageableListView.this.setRowsPerPage(this.rowsPerPage);
        }

        public String toString() {
            return "RowsPerPageChange[component: " + PageableListView.this.getPath() + ", prefix: " + this.rowsPerPage + "]";
        }
    }

    private class CurrentPageChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final int currentPage;

        CurrentPageChange(int currentPage) {
            this.currentPage = currentPage;
        }

        public void undo() {
            PageableListView.this.setCurrentPage(this.currentPage);
        }

        public String toString() {
            return "CurrentPageChange[currentPage: " + this.currentPage + "]";
        }
    }
}

