/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.markup.transformer.AbstractOutputTransformerContainer;
import org.apache.wicket.markup.transformer.XsltTransformer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class XsltOutputTransformerContainer
extends AbstractOutputTransformerContainer {
    private static final long serialVersionUID = 1L;
    private final String xslFile;

    public XsltOutputTransformerContainer(String id, IModel model, String xslFilePath) {
        super(id);
        this.xslFile = xslFilePath;
        this.setTransformBodyOnly(false);
        this.add(new AttributeModifier("xmlns:wicket", true, (IModel)new Model((Serializable)((Object)"http://wicket.apache.org"))));
    }

    public XsltOutputTransformerContainer(String id, IModel model) {
        this(id, model, null);
    }

    public XsltOutputTransformerContainer(String id) {
        this(id, null, null);
    }

    public String getMarkupType() {
        return "xsl";
    }

    public CharSequence transform(Component component, CharSequence output) throws Exception {
        return new XsltTransformer(this.xslFile).transform(component, output);
    }
}

