/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.target.component.IComponentRequestTarget;
import org.apache.wicket.request.target.component.PageRequestTarget;

public class ComponentRequestTarget
implements IComponentRequestTarget {
    private final Component component;

    public ComponentRequestTarget(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 'component' must be not null");
        }
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond(RequestCycle requestCycle) {
        Page page = this.component.getPage();
        if (page != null) {
            page.startComponentRender(this.component);
        }
        if (this.component instanceof Page) {
            new PageRequestTarget((Page)this.component).respond(requestCycle);
        } else {
            try {
                this.component.renderComponent();
            }
            finally {
                this.component.getPage().detach();
            }
        }
        if (page != null) {
            page.endComponentRender(this.component);
        }
    }

    public final Component getComponent() {
        return this.component;
    }

    public void detach(RequestCycle requestCycle) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentRequestTarget) {
            ComponentRequestTarget that = (ComponentRequestTarget)obj;
            return this.component.equals(that.component);
        }
        return false;
    }

    public int hashCode() {
        int result = "ComponentRequestTarget".hashCode();
        return 17 * (result += this.component.hashCode());
    }

    public String toString() {
        return "[ComponentRequestTarget@" + this.hashCode() + " " + this.component + "]";
    }
}

