/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.util.string.Strings;

public class WicketTesterHelper {
    public static List getComponentData(Page page) {
        final ArrayList data = new ArrayList();
        if (page != null) {
            page.visitChildren(new Component.IVisitor(){

                public Object component(Component component) {
                    ComponentData object = new ComponentData();
                    String name = component.getClass().getName();
                    if (name.indexOf("$") > 0) {
                        name = component.getClass().getSuperclass().getName();
                    }
                    name = Strings.lastPathComponent(name, ':');
                    object.path = component.getPageRelativePath();
                    object.type = name;
                    try {
                        object.value = component.getModelObjectAsString();
                    }
                    catch (Exception e) {
                        object.value = e.getMessage();
                    }
                    data.add(object);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
        }
        return data;
    }

    public static void assertEquals(Collection expects, Collection actuals) {
        if (!expects.containsAll(actuals) || !actuals.containsAll(expects)) {
            WicketTesterHelper.failWithVerboseMessage(expects, actuals);
        }
    }

    public static void failWithVerboseMessage(Collection expects, Collection actuals) {
        Assert.fail((String)("\nexpect (" + expects.size() + "):\n" + WicketTesterHelper.asLined(expects) + "\nbut was (" + actuals.size() + "):\n" + WicketTesterHelper.asLined(actuals)));
    }

    public static String asLined(Collection objects) {
        StringBuffer lined = new StringBuffer();
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            String objectString = iter.next().toString();
            lined.append("   ");
            lined.append(objectString);
            if (!iter.hasNext()) continue;
            lined.append("\n");
        }
        return lined.toString();
    }

    public static class ComponentData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        public String path;
        public String type;
        public String value;
    }
}

