/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.StringValidator;

public class PatternValidator
extends StringValidator {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;

    public PatternValidator(String pattern) {
        this(Pattern.compile(pattern));
    }

    public PatternValidator(String pattern, int flags) {
        this(Pattern.compile(pattern, flags));
    }

    public PatternValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public PatternValidator(MetaPattern pattern) {
        this(pattern.pattern());
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    protected Map variablesMap(IValidatable validatable) {
        Map map = super.variablesMap(validatable);
        map.put("pattern", this.pattern.pattern());
        return map;
    }

    public String toString() {
        return "[PatternValidator pattern = " + this.pattern + "]";
    }

    protected void onValidate(IValidatable validatable) {
        if (!this.pattern.matcher((String)validatable.getValue()).matches()) {
            this.error(validatable);
        }
    }
}

