/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.IOptionRenderer;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SelectOptions
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private boolean recreateChoices = false;
    private final IOptionRenderer renderer;

    public SelectOptions(String id, IModel model, IOptionRenderer renderer) {
        super(id, model);
        this.renderer = renderer;
        this.setRenderBodyOnly(true);
    }

    public SelectOptions(String id, Collection elements, IOptionRenderer renderer) {
        this(id, (IModel)new Model((Serializable)((Object)elements)), renderer);
    }

    public SelectOptions setRecreateChoices(boolean refresh) {
        this.recreateChoices = refresh;
        return this;
    }

    protected final void onPopulate() {
        if (this.size() == 0 || this.recreateChoices) {
            this.removeAll();
            Object modelObject = this.getModelObject();
            if (modelObject != null) {
                if (!(modelObject instanceof Collection)) {
                    throw new WicketRuntimeException("Model object " + modelObject + " not a collection");
                }
                Iterator it = ((Collection)modelObject).iterator();
                while (it.hasNext()) {
                    WebMarkupContainer row = new WebMarkupContainer(this.newChildId());
                    row.setRenderBodyOnly(true);
                    this.add((Component)row);
                    Object value = it.next();
                    String text = this.renderer.getDisplayValue(value);
                    IModel model = this.renderer.getModel(value);
                    row.add((Component)this.newOption(text, model));
                }
            }
        }
    }

    protected SelectOption newOption(String text, IModel model) {
        return new SimpleSelectOption("option", model, text);
    }

    private static class SimpleSelectOption
    extends SelectOption {
        private final String text;
        private static final long serialVersionUID = 1L;

        public SimpleSelectOption(String id, IModel model, String text) {
            super(id, model);
            this.text = text;
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            this.replaceComponentTagBody(markupStream, openTag, this.text);
        }
    }
}

