/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.ee.jms;

import java.lang.reflect.Method;
import javax.context.CreationalContext;
import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jboss.webbeans.bean.ee.AbstractResourceMethodHandler;
import org.jboss.webbeans.bean.ee.jms.ConnectionContextual;
import org.jboss.webbeans.bean.ee.jms.MessageConsumerContextual;
import org.jboss.webbeans.bean.ee.jms.MessageProducerContextual;
import org.jboss.webbeans.bean.ee.jms.SessionContextual;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.DependentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JmsMethodHandler<C extends Connection, S extends Session, MP extends MessageProducer, MC extends MessageConsumer>
extends AbstractResourceMethodHandler {
    private static final long serialVersionUID = -2598920314236475437L;

    public JmsMethodHandler(String jndiName, String mappedName) {
        super(jndiName, mappedName);
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        if (method.getName().equals("close")) {
            throw new UnsupportedOperationException("Cannot call close on a Web Beans managed JMS resource");
        }
        return super.invoke(self, method, proceed, args);
    }

    @Override
    protected Object getProxiedInstance(Class<?> declaringClass) {
        if (Connection.class.isAssignableFrom(declaringClass)) {
            return this.getConnection(this.getConnectionContextual());
        }
        if (Session.class.isAssignableFrom(declaringClass)) {
            return this.getSession(this.getSessionContextual());
        }
        if (MessageConsumer.class.isAssignableFrom(declaringClass)) {
            return this.getQueueReceiver(this.getMessageConsumerContextual());
        }
        if (MessageProducer.class.isAssignableFrom(declaringClass)) {
            return this.getMessageProducer(this.getMessageProducerContextual());
        }
        throw new IllegalStateException("Cannot create proxy for " + declaringClass);
    }

    protected abstract ConnectionContextual<C> getConnectionContextual();

    protected abstract SessionContextual<S> getSessionContextual();

    protected abstract MessageConsumerContextual<MC> getMessageConsumerContextual();

    protected abstract MessageProducerContextual<MP> getMessageProducerContextual();

    protected abstract S createSessionFromConnection(ConnectionContextual<C> var1);

    protected C getConnection(ConnectionContextual<C> connectionContexual) {
        return (C)((Connection)ApplicationContext.instance().get(connectionContexual, new CreationalContext<C>(){

            @Override
            public void push(C incompleteInstance) {
            }
        }));
    }

    private S getSession(SessionContextual<S> sessionContextual) {
        return (S)((Session)DependentContext.instance().get(sessionContextual, new CreationalContext<S>(){

            @Override
            public void push(S incompleteInstance) {
            }
        }));
    }

    private MP getMessageProducer(MessageProducerContextual<MP> messageProducerContextual) {
        return (MP)((MessageProducer)DependentContext.instance().get(messageProducerContextual, new CreationalContext<MP>(){

            @Override
            public void push(MP incompleteInstance) {
            }
        }));
    }

    private MC getQueueReceiver(MessageConsumerContextual<MC> messageConsumerContextual) {
        return (MC)((MessageConsumer)DependentContext.instance().get(messageConsumerContextual, new CreationalContext<MC>(){

            @Override
            public void push(MC incompleteInstance) {
            }
        }));
    }
}

