/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.context.Conversation;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationEntry {
    private static LogProvider log = Logging.getLogProvider(ConversationEntry.class);
    private Conversation conversation;
    private Future<?> terminationHandle;
    private ReentrantLock concurrencyLock;

    protected ConversationEntry(Conversation conversation, Future<?> terminationHandle) {
        this.conversation = new ConversationImpl(conversation);
        this.terminationHandle = terminationHandle;
        this.concurrencyLock = new ReentrantLock();
        log.trace("Created new conversation entry for conversation " + conversation);
    }

    public static ConversationEntry of(Conversation conversation, Future<?> terminationHandle) {
        return new ConversationEntry(conversation, terminationHandle);
    }

    public boolean cancelTermination() {
        if (this.terminationHandle.isCancelled()) {
            return true;
        }
        boolean success = this.terminationHandle.cancel(false);
        if (success) {
            log.trace("Termination of conversation " + this.conversation + " cancelled");
        } else {
            log.warn("Failed to cancel termination of conversation " + this.conversation);
        }
        return success;
    }

    public void destroy(HttpSession session) {
        log.debug("Destroying conversation " + this.conversation);
        if (!this.terminationHandle.isCancelled()) {
            this.cancelTermination();
        }
        ConversationContext terminationContext = new ConversationContext();
        terminationContext.setBeanStore(new ConversationBeanStore(session, this.conversation.getId()));
        terminationContext.destroy();
        log.trace("Conversation " + this.conversation + " destroyed");
    }

    public boolean lock(long timeout) throws InterruptedException {
        boolean success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        if (success) {
            log.trace("Conversation " + this.conversation + " locked");
        } else {
            log.warn("Failed to lock conversation " + this.conversation + " in " + timeout + "ms");
        }
        return success;
    }

    public boolean unlock() {
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace("Unlocked conversation " + this.conversation);
        } else {
            log.warn("Unlock attempt by non-owner on conversation " + this.conversation);
        }
        return !this.concurrencyLock.isLocked();
    }

    public void reScheduleTermination(Future<?> terminationHandle) {
        this.terminationHandle = terminationHandle;
        log.trace("Conversation " + this.conversation + " re-scheduled for termination");
    }

    public Conversation getConversation() {
        return this.conversation;
    }
}

