/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.util.HashSet;
import java.util.Set;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.Produces;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    public static boolean isPassivatingBean(Bean<?> bean, ManagerImpl manager) {
        if (bean instanceof EnterpriseBean) {
            return ((EnterpriseBean)bean).getEjbDescriptor().isStateful();
        }
        return manager.getServices().get(MetaDataCache.class).getScopeModel(bean.getScopeType()).isPassivating();
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static Set<FieldInjectionPoint<?>> getFieldInjectionPoints(AnnotatedClass<?> annotatedItem, Bean<?> declaringBean) {
        HashSet injectableFields = new HashSet();
        for (AnnotatedField<?> annotatedField : annotatedItem.getMetaAnnotatedFields(BindingType.class)) {
            if (annotatedField.isAnnotationPresent(Produces.class)) continue;
            if (annotatedField.isStatic()) {
                throw new DefinitionException("Don't place binding annotations on static fields " + annotatedField);
            }
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            FieldInjectionPoint<?> fieldInjectionPoint = FieldInjectionPoint.of(declaringBean, annotatedField);
            injectableFields.add(fieldInjectionPoint);
        }
        return injectableFields;
    }
}

