/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Transaction;

abstract class TransactionRunner {
    private final Transaction txn;
    private final boolean finishTxn;

    protected TransactionRunner(Transaction txn, boolean finishTxn) {
        if (txn == null && finishTxn) {
            throw new IllegalArgumentException("Cannot have a null txn when finishTxn is true.  This almost certainly represents a programming error on the part of the App Engine team.  Please report this via standard support channels and accept our humblest apologies.");
        }
        this.txn = txn;
        this.finishTxn = finishTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInTransaction() {
        boolean success = false;
        try {
            this.run();
            success = true;
        }
        finally {
            if (this.finishTxn) {
                if (success) {
                    this.txn.commit();
                } else {
                    this.txn.rollback();
                }
            }
        }
    }

    protected abstract void run();
}

