/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class FilterForm
extends Form {
    private static final long serialVersionUID = 1L;
    private final HiddenField hidden;
    private final IFilterStateLocator locator;

    public FilterForm(String id, IFilterStateLocator locator) {
        super(id, (IModel)new FilterStateModel(locator));
        this.locator = locator;
        this.hidden = new HiddenField("focus-tracker", (IModel)new Model());
        this.hidden.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("id", (CharSequence)FilterForm.this.getFocusTrackerFieldCssId());
                super.onComponentTag(component, tag);
            }
        });
        this.add((Component)this.hidden);
        this.add((Component)new WebMarkupContainer("focus-restore"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                AppendingStringBuffer script = new AppendingStringBuffer((CharSequence)"<script>_filter_focus_restore('").append(FilterForm.this.getFocusTrackerFieldCssId()).append("');</script>");
                this.replaceComponentTagBody(markupStream, openTag, (CharSequence)script);
            }
        });
    }

    public final String getFocusTrackerFieldCssId() {
        return this.hidden.getPageRelativePath();
    }

    public final IFilterStateLocator getStateLocator() {
        return this.locator;
    }

    public final void enableFocusTracking(FormComponent fc) {
        fc.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("id", (CharSequence)component.getMarkupId());
                tag.put("onfocus", (CharSequence)FilterForm.this.getFocusTrackingHandler(component));
                super.onComponentTag(component, tag);
            }
        });
    }

    public final String getFocusTrackingHandler(Component component) {
        return "_filter_focus(this, '" + this.getFocusTrackerFieldCssId() + "');";
    }

    private static class FilterStateModel
    extends Model {
        private static final long serialVersionUID = 1L;
        private IFilterStateLocator locator;

        public FilterStateModel(IFilterStateLocator locator) {
            if (locator == null) {
                throw new IllegalArgumentException("argument [locator] cannot be null");
            }
            this.locator = locator;
        }

        public Object getObject() {
            return this.locator.getFilterState();
        }

        public void setObject(Object object) {
            this.locator.setFilterState(object);
        }
    }
}

