/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.Localiser;

public class JDOQLParser
implements Parser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private static String[] jdoqlMethodNames = new String[]{"contains", "get", "containsKey", "containsValue", "isEmpty", "size", "toLowerCase", "toUpperCase", "indexOf", "matches", "substring", "startsWith", "endsWith", "Math.abs", "Math.sqrt", "JDOHelper.getObjectId", "JDOHelper.getVersion"};
    private String jdoqlMode = "DataNucleus";
    private Lexer p;
    private Stack<Node> stack = new Stack();
    private static String paramPrefixes = ":";
    int parameterPosition = 0;

    public JDOQLParser(Map options) {
        if (options != null && options.containsKey("jdoql.level")) {
            this.jdoqlMode = (String)options.get("jdoql.level");
        }
    }

    public Node parse(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        Node result = this.processExpression();
        if (this.p.ci.getIndex() != this.p.ci.getEndIndex()) {
            String unparsed = this.p.getInput().substring(this.p.ci.getIndex());
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + unparsed);
        }
        return result;
    }

    public Node parseVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] parseFrom(String expression) {
        return null;
    }

    public Node[] parseOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.processOrderExpression();
    }

    public Node[] parseTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] parseVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable type", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable name", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            String varName = (String)nodeVariable.getNodeValue();
            if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(varName)) {
                throw new NucleusUserException(LOCALISER.msg("021105", (Object)varName));
            }
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] parseParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.processExpression();
            if (this.p.parseString("asc") || this.p.parseString("ascending") || this.p.parseString("ASC") || this.p.parseString("ASCENDING")) {
                expr = new Node(4, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseString("desc") || this.p.parseString("descending") || this.p.parseString("DESC") || this.p.parseString("DESCENDING")) {
                expr = new Node(4, "descending");
                this.stack.push(expr);
            }
            expr = new Node(4, "order");
            expr.insertChildNode(this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processConditionalOrExpression();
        return this.stack.peek();
    }

    private void processConditionalOrExpression() {
        this.processConditionalAndExpression();
        while (this.p.parseString("||")) {
            this.processConditionalAndExpression();
            Node expr = new Node(4, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processConditionalAndExpression() {
        this.processInclusiveOrExpression();
        while (this.p.parseString("&&")) {
            this.processInclusiveOrExpression();
            Node expr = new Node(4, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processInclusiveOrExpression() {
        this.processExclusiveOrExpression();
        while (this.p.parseChar('|', '|')) {
            this.processExclusiveOrExpression();
            Node expr = new Node(4, "|");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processExclusiveOrExpression() {
        this.processAndExpression();
        while (this.p.parseChar('^')) {
            this.processAndExpression();
            Node expr = new Node(4, "^");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.p.parseChar('&', '&')) {
            this.processRelationalExpression();
            Node expr = new Node(4, "&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node expr;
            if (this.p.parseString("==")) {
                this.processAdditiveExpression();
                expr = new Node(4, "==");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("!=")) {
                this.processAdditiveExpression();
                expr = new Node(4, "!=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("=")) {
                throw new QueryCompilerSyntaxException("Invalid operator \"=\". Did you mean to use \"==\"?");
            }
            if (this.p.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(4, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(4, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(4, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('>')) {
                this.processAdditiveExpression();
                expr = new Node(4, ">");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseString("instanceof")) break;
            this.processAdditiveExpression();
            expr = new Node(4, "instanceof");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.processMultiplicativeExpression();
            expr = new Node(4, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(4, "NEG");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('~')) {
            this.processUnaryExpression();
            Node expr = new Node(4, "~");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseChar('!')) {
            this.processUnaryExpression();
            Node expr = new Node(4, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        if (this.p.parseStringIgnoreCase("DISTINCT")) {
            Node distinctNode = new Node(4, "DISTINCT");
            this.processIdentifier();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.processCreator() || this.processLiteral() || this.processMethod()) {
            return;
        }
        Node castNode = null;
        int sizeBeforeBraceProcessing = this.stack.size();
        boolean braceProcessing = false;
        if (this.processCast()) {
            castNode = this.stack.pop();
        } else if (this.p.parseChar('(')) {
            this.processExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            if (!this.p.parseChar('.')) {
                return;
            }
            braceProcessing = true;
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        if (castNode != null) {
            this.stack.push(castNode);
        }
        int size = this.stack.size();
        if (braceProcessing) {
            size = sizeBeforeBraceProcessing + 1;
        }
        while (this.p.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            peek.appendChildNode(top);
        }
    }

    private boolean processCast() {
        String typeName = this.p.parseCast();
        if (typeName == null) {
            return false;
        }
        Node castNode = new Node(8, typeName);
        this.stack.push(castNode);
        return true;
    }

    private boolean processCreator() {
        if (this.p.parseString("new")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = this.stack.pop();
            Node newExpr = new Node(5);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (this.stack.size() > 0) {
                Node primExprNode = this.stack.peek();
                if (primExprNode != null && primExprNode.getNodeValue().equals("JDOHelper")) {
                    if (method.equals("getObjectId")) {
                        method = "JDOHelper.getObjectId";
                        this.stack.pop();
                    } else if (method.equals("getVersion")) {
                        method = "JDOHelper.getVersion";
                        this.stack.pop();
                    }
                }
                if (primExprNode != null && primExprNode.getNodeValue().equals("Math")) {
                    if (method.equals("abs")) {
                        method = "Math.abs";
                        this.stack.pop();
                    } else if (method.equals("sqrt")) {
                        method = "Math.sqrt";
                        this.stack.pop();
                    }
                }
            }
            if (this.jdoqlMode.equals("JDO2") && Arrays.binarySearch(jdoqlMethodNames, method) < 0) {
                throw new QueryCompilerSyntaxException("Query uses method \"" + method + "\" but this is not a standard JDOQL method name");
            }
            Node expr = new Node(1, method);
            if (!this.p.parseChar(')')) {
                int numArgs = 0;
                do {
                    this.processExpression();
                    expr.addProperty(this.stack.pop());
                    ++numArgs;
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? new Character(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = new Long(iLiteral.longValue());
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteral()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(0, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null) {
            return false;
        }
        char first = id.charAt(0);
        if (first == ':') {
            ParameterNode expr = new ParameterNode(7, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(3, id);
        this.stack.push(expr);
        return true;
    }
}

