/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.StoreData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;

public class StoreDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected Map<Object, StoreData> storeDataByClass = Collections.synchronizedMap(new HashMap());
    protected MultiMap storeDataByAppIdClass = new MultiMap();
    protected Map savedStoreDataByClass;
    protected MultiMap savedStoreDataByAppIdClass;

    public void clear() {
        if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
            NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032002"));
        }
        this.storeDataByClass.clear();
        this.storeDataByAppIdClass.clear();
    }

    protected void registerStoreData(StoreData data) {
        if (data.isFCO()) {
            this.storeDataByClass.put(data.getName(), data);
            ClassMetaData cmd = (ClassMetaData)data.getMetaData();
            if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                this.storeDataByAppIdClass.put(cmd.getObjectidClass(), data);
            }
        } else {
            this.storeDataByClass.put(data.getMetaData(), data);
        }
        if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
            NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032001", data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StoreData[] getStoreDataForProperties(String key1, Object value1, String key2, Object value2) {
        HashSet<StoreData> results = null;
        Collection<StoreData> storeDatas = this.storeDataByClass.values();
        Map<Object, StoreData> map = this.storeDataByClass;
        synchronized (map) {
            for (StoreData data : storeDatas) {
                if (data.getProperties() == null) continue;
                Object prop1Value = data.getProperties().get(key1);
                Object prop2Value = data.getProperties().get(key2);
                if (prop1Value == null || !prop1Value.equals(value1) || prop2Value == null || !prop2Value.equals(value2)) continue;
                if (results == null) {
                    results = new HashSet<StoreData>();
                }
                results.add(data);
            }
        }
        if (results != null) {
            return results.toArray(new StoreData[results.size()]);
        }
        return null;
    }

    public boolean managesClass(String className) {
        return this.storeDataByClass.containsKey(className);
    }

    public Collection getManagedStoreData() {
        return Collections.unmodifiableCollection(this.storeDataByClass.values());
    }

    public StoreData get(String className) {
        return this.storeDataByClass.get(className);
    }

    public StoreData get(AbstractMemberMetaData apmd) {
        return this.storeDataByClass.get(apmd);
    }

    public Collection getByPrimaryKeyClass(String className) {
        return (Collection)this.storeDataByAppIdClass.get(className);
    }

    public int size() {
        return this.storeDataByClass.size();
    }

    public void begin() {
        this.savedStoreDataByClass = new HashMap<Object, StoreData>(this.storeDataByClass);
        this.savedStoreDataByAppIdClass = new MultiMap(this.storeDataByAppIdClass);
    }

    public void rollback() {
        this.storeDataByClass = this.savedStoreDataByClass;
        this.storeDataByAppIdClass = this.savedStoreDataByAppIdClass;
    }

    public void commit() {
        this.savedStoreDataByClass = null;
        this.savedStoreDataByAppIdClass = null;
    }
}

