/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapStoreQueryable;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.MapStore;

public abstract class AbstractMapStore
extends BaseContainerStore
implements MapStore,
MapStoreQueryable {
    protected boolean iterateUsingDiscriminator = false;
    protected DatastoreContainerObject mapTable;
    protected DatastoreClass valueTable;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected boolean keysAreEmbedded;
    protected boolean keysAreSerialised;
    protected boolean valuesAreEmbedded;
    protected boolean valuesAreSerialised;
    protected final DatastoreIdentifier elmIdentifier;
    protected final AbstractMapStoreSpecialization specialization;

    public AbstractMapStore(StoreManager storeMgr, AbstractMapStoreSpecialization specialization) {
        super(storeMgr);
        this.elmIdentifier = ((MappedStoreManager)storeMgr).getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "ELEMENT");
        this.specialization = specialization;
    }

    public boolean keysAreEmbedded() {
        return this.keysAreEmbedded;
    }

    public boolean keysAreSerialised() {
        return this.keysAreSerialised;
    }

    public boolean valuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean valuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public boolean containsKey(StateManager sm, Object key) {
        if (key == null) {
            return false;
        }
        try {
            this.getValue(sm, key);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean containsValue(StateManager sm, Object value) {
        if (value == null) {
            return false;
        }
        if (!this.validateValueForReading(sm, value)) {
            return false;
        }
        return this.specialization.containsValue(sm, value, this);
    }

    public Object get(StateManager sm, Object key) {
        try {
            return this.getValue(sm, key);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void putAll(StateManager sm, Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put(sm, e.getKey(), e.getValue());
        }
    }

    protected void validateKeyType(ClassLoaderResolver clr, Object key) {
        if (key == null) {
            throw new NullPointerException(LOCALISER.msg("056062"));
        }
        if (!clr.isAssignableFrom(this.keyType, key.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056064", (Object)key.getClass().getName(), (Object)this.keyType));
        }
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value != null && !clr.isAssignableFrom(this.valueType, value.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056065", (Object)value.getClass().getName(), (Object)this.valueType));
        }
    }

    protected boolean validateKeyForReading(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(key == null || om.getApiAdapter().isPersistent(key) && om == om.getApiAdapter().getObjectManager(key) || om.getApiAdapter().isDetached(key))) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateValueForReading(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(value == null || om.getApiAdapter().isPersistent(value) && om == om.getApiAdapter().getObjectManager(value) || om.getApiAdapter().isDetached(value))) {
                return false;
            }
        }
        return true;
    }

    protected void validateKeyForWriting(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            SCOUtils.validateObjectForWriting(om, key, null);
        }
    }

    protected void validateValueForWriting(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            SCOUtils.validateObjectForWriting(om, value, null);
        }
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        return null;
    }

    protected Object getValue(StateManager sm, Object key) throws NoSuchElementException {
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        QueryExpression stmt = this.getGetStatement(sm, key);
        ResultObjectFactory rof = this.newResultObjectFactory(sm, stmt, false, true);
        ObjectManager om = sm.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        return this.specialization.getValue(sm, key, stmt, tx, useUpdateLock, this, rof);
    }

    public boolean updateEmbeddedKey(StateManager sm, Object key, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.keyMapping != null && this.keyMapping instanceof EmbeddedKeyPCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedKeyPCMapping)this.keyMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.specialization.updatedEmbeddedKey(sm, key, fieldNumber, newValue, fieldMapping, this);
        }
        return modified;
    }

    public boolean updateEmbeddedValue(StateManager sm, Object value, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.valueMapping != null && this.valueMapping instanceof EmbeddedValuePCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedValuePCMapping)this.valueMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.specialization.updateEmbeddedValue(sm, value, fieldNumber, newValue, fieldMapping, this);
        }
        return modified;
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        JavaTypeMapping verMapping;
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
            if (stmt.hasNucleusTypeExpression()) {
                mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            return storeMgr.newResultObjectFactory(this.valueTable, this.vmd, mappingDefinition, ignoreCache, false, null, clr.classForName(this.valueType));
        }
        StatementMappingIndex[] stmtMappings = null;
        int[] prefetchFieldNumbers = null;
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.vmd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.vmd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int[] fn = new int[fieldNumbers.length];
            int prefetchFieldCount = 0;
            int fieldCount = this.vmd.getNoOfInheritedManagedMembers() + this.vmd.getNoOfManagedMembers();
            stmtMappings = new StatementMappingIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m = this.valueTable.getMemberMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]));
                if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                stmtMappings[fieldNumbers[i]] = new StatementMappingIndex(m);
                ExpressionHelper.selectMapping(stmtMappings[fieldNumbers[i]], stmt, stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : null, clr);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
        } else {
            AbstractClassMetaData cmd = this.vmd;
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                stmtMappings = new StatementMappingIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    JavaTypeMapping m = this.valueTable.getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    stmtMappings[prefetchFieldNumbers[i]] = new StatementMappingIndex(m);
                    ExpressionHelper.selectMapping(stmtMappings[prefetchFieldNumbers[i]], stmt, stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : null, clr);
                }
            }
        }
        StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
        for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
            mappingDefinition.addMappingForMember(prefetchFieldNumbers[i], stmtMappings[prefetchFieldNumbers[i]]);
        }
        if (this.valueTable.getIdentityType() == IdentityType.DATASTORE) {
            int[] datastoreIndex = stmt.select(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : stmt.getMainTableAlias(), this.valueTable.getDataStoreObjectIdMapping(), true);
            StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(this.valueTable.getDataStoreObjectIdMapping());
            datastoreMappingIdx.setColumnPositions(datastoreIndex);
            mappingDefinition.addMappingForMember(StatementMappingForClass.MEMBER_DATASTORE_ID, datastoreMappingIdx);
        }
        if ((verMapping = this.valueTable.getVersionMapping(true)) != null) {
            int[] versionIndex = stmt.select(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : stmt.getMainTableAlias(), verMapping, true);
            StatementMappingIndex versionMappingIdx = new StatementMappingIndex(verMapping);
            versionMappingIdx.setColumnPositions(versionIndex);
            mappingDefinition.addMappingForMember(StatementMappingForClass.MEMBER_VERSION, versionMappingIdx);
        }
        if (stmt.hasNucleusTypeExpression()) {
            mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
        }
        return storeMgr.newResultObjectFactory(storeMgr.getDatastoreClass(this.getValueType(), clr), this.vmd, mappingDefinition, ignoreCache, this.iterateUsingDiscriminator, null, clr.classForName(this.valueType));
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInMapExpr));
        stmt.select(mapTableAlias, this.valueMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    public ScalarExpression[] joinKeysToGet(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapTableAlias, Class filteredKeyType, DatastoreIdentifier keyTableAlias, DatastoreIdentifier valueTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class value_class = clr.classForName(this.valueType);
        return this.joinKeysValuesTo(stmt, parentStmt, ownerMapping, te, mapTableAlias, filteredKeyType, value_class, null, null, keyTableAlias, valueTableAlias);
    }

    public JavaTypeMapping getValueMapping() {
        return this.valueMapping;
    }

    public JavaTypeMapping getKeyMapping() {
        return this.keyMapping;
    }

    public boolean isValuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean isValuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public DatastoreContainerObject getMapTable() {
        return this.mapTable;
    }

    public AbstractClassMetaData getKmd() {
        return this.kmd;
    }

    public AbstractClassMetaData getVmd() {
        return this.vmd;
    }
}

